/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.java.parser.BaseJavaTerm;
import com.liferay.portal.tools.java.parser.JavaAnnotation;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaType;
import java.util.List;

public class JavaClassDefinition
extends BaseJavaTerm {
    private final JavaType _classJavaType;
    private List<JavaType> _extendedClassJavaTypes;
    private List<JavaType> _implementedClassJavaTypes;
    private final List<JavaAnnotation> _javaAnnotations;
    private final List<JavaSimpleValue> _modifiers;
    private final String _type;

    public JavaClassDefinition(String type, List<JavaAnnotation> javaAnnotations, List<JavaSimpleValue> modifiers, JavaType classJavaType) {
        this._type = type;
        this._javaAnnotations = javaAnnotations;
        this._modifiers = modifiers;
        this._classJavaType = classJavaType;
    }

    public void setExtendedClassJavaTypes(List<JavaType> extendedClassJavaTypes) {
        this._extendedClassJavaTypes = extendedClassJavaTypes;
    }

    public void setImplementedClassJavaTypes(List<JavaType> implementedClassJavaTypes) {
        this._implementedClassJavaTypes = implementedClassJavaTypes;
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength) {
        StringBundler sb = new StringBundler();
        if (!this._javaAnnotations.isEmpty()) {
            for (int i = 0; i < this._javaAnnotations.size(); ++i) {
                if (i == 0) {
                    this.appendNewLine(sb, this._javaAnnotations.get(i), indent, prefix, "", maxLineLength);
                    prefix = "";
                    continue;
                }
                this.appendNewLine(sb, this._javaAnnotations.get(i), indent, maxLineLength);
            }
            sb.append("\n");
        }
        sb.append(indent);
        indent = "\t" + indent;
        int index = sb.index();
        if (!this._modifiers.isEmpty()) {
            this.append(sb, this._modifiers, " ", indent, prefix, " ", -1);
            prefix = "";
        }
        this.appendSingleLine(sb, this._classJavaType, StringBundler.concat((String[])new String[]{prefix, this._type, " "}), "", -1);
        if (this._extendedClassJavaTypes != null) {
            this.appendSingleLine(sb, this._extendedClassJavaTypes, " extends ", "", -1);
        }
        if (this._implementedClassJavaTypes != null) {
            this.appendSingleLine(sb, this._implementedClassJavaTypes, " implements ", "", -1);
        }
        sb.append(suffix);
        if (maxLineLength == -1 || this.getLineLength(this.getLastLine(sb)) <= maxLineLength) {
            return sb.toString();
        }
        sb.setIndex(index);
        if (!this._modifiers.isEmpty()) {
            this.append(sb, this._modifiers, " ", indent, prefix, " ", maxLineLength);
            prefix = "";
        }
        sb.append(prefix);
        sb.append(this._type);
        sb.append(" ");
        if (this._extendedClassJavaTypes != null) {
            indent = this.append(sb, this._classJavaType, indent, maxLineLength, false);
            if (this._implementedClassJavaTypes != null) {
                this.appendNewLine(sb, this._extendedClassJavaTypes, indent, "extends ", " ", maxLineLength);
                this.append(sb, this._implementedClassJavaTypes, indent, "implements ", suffix, maxLineLength);
            } else {
                this.appendNewLine(sb, this._extendedClassJavaTypes, indent, "extends ", suffix, maxLineLength);
            }
            return sb.toString();
        }
        if (this._implementedClassJavaTypes != null) {
            indent = this.append(sb, this._classJavaType, indent, maxLineLength, false);
            this.appendNewLine(sb, this._implementedClassJavaTypes, indent, "implements ", suffix, maxLineLength);
        } else {
            this.append(sb, this._classJavaType, indent, "", suffix, maxLineLength, false);
        }
        return sb.toString();
    }
}

