/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.internal.util;

import com.liferay.portal.tools.bundle.support.BundleSupport;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class FileUtil {
    private static final long _FILE_LENGTH_KB = 1024L;
    private static final long _FILE_LENGTH_MB = 0x100000L;

    public static void copyDirectory(final Path dirPath, final Path destinationDirPath) throws IOException {
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Path relativePath = dirPath.relativize(path);
                Path destinationPath = destinationDirPath.resolve(relativePath);
                FileUtil.copyFile(path, destinationPath);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyFile(Path path, Path destinationPath) throws IOException {
        Path parentPath = destinationPath.getParent();
        if (parentPath != null) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        Files.copy(path, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        Files.setLastModifiedTime(destinationPath, Files.getLastModifiedTime(path, new LinkOption[0]));
    }

    public static void deleteDirectory(Path dirPath) throws IOException {
        if (Files.notExists(dirPath, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException ioException) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String getFileLength(long length) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        if (length > 0x100000L) {
            return decimalFormat.format((double)length / 1048576.0) + " MB";
        }
        if (length > 1024L) {
            return decimalFormat.format((double)length / 1024.0) + " KB";
        }
        return decimalFormat.format(length) + " B";
    }

    public static File getJarFile() throws Exception {
        ProtectionDomain protectionDomain = BundleSupport.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        return new File(url.toURI());
    }

    public static boolean isPosixSupported(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        Set<String> supportedFileAttributeViews = fileSystem.supportedFileAttributeViews();
        return supportedFileAttributeViews.contains("posix");
    }

    public static String read(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public static void sevenZip(Path sourcePath, File sevenZipFile, boolean includeFolder) throws Exception {
        final Path parentPath = includeFolder ? sourcePath.getParent() : sourcePath;
        try (final SevenZOutputFile sevenZOutputFile = new SevenZOutputFile(sevenZipFile);){
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path entryPath = parentPath.relativize(path);
                    FileUtil._appendSevenZip(path.toFile(), entryPath, sevenZOutputFile);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void tar(Path sourcePath, File tarFile, boolean includeFolder) throws Exception {
        final Path parentPath = includeFolder ? sourcePath.getParent() : sourcePath;
        try (final TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(new GzipCompressorOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            tarArchiveOutputStream.setLongFileMode(2);
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path entryPath = parentPath.relativize(path);
                    FileUtil._appendTar(path.toFile(), entryPath, tarArchiveOutputStream);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void unpack(Path path, Path destinationDirPath, int stripComponents) throws Exception {
        String fileName = String.valueOf(path.getFileName());
        if (fileName.endsWith(".gz") || fileName.endsWith(".tar") || fileName.endsWith(".tgz")) {
            FileUtil._untar(path, destinationDirPath, stripComponents);
        } else if (fileName.endsWith(".zip")) {
            FileUtil._unzip(path, destinationDirPath, stripComponents);
        } else if (fileName.endsWith(".7z")) {
            FileUtil._unsevenZip(path, destinationDirPath, stripComponents);
        } else {
            throw new UnsupportedOperationException("Unsupported format for " + fileName);
        }
    }

    public static void zip(Path sourcePath, File zipFile, boolean includeFolder) throws Exception {
        final Path parentPath = includeFolder ? sourcePath.getParent() : sourcePath;
        try (final FileSystem fileSystem = FileUtil._createFileSystem(zipFile.toPath(), true);){
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path entryPath = parentPath.relativize(path);
                    FileUtil.copyFile(path, fileSystem.getPath(entryPath.toString(), new String[0]));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void _appendSevenZip(File entryFile, Path entryPath, SevenZOutputFile sevenZOutputFile) throws IOException {
        SevenZArchiveEntry sevenZArchiveEntry = sevenZOutputFile.createArchiveEntry(entryFile, entryPath.toString());
        sevenZOutputFile.putArchiveEntry(sevenZArchiveEntry);
        sevenZOutputFile.write(Files.readAllBytes(entryFile.toPath()));
        sevenZOutputFile.closeArchiveEntry();
    }

    private static void _appendTar(File entryFile, Path entryPath, TarArchiveOutputStream tarArchiveOutputStream) throws IOException {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(entryPath.toFile());
        tarArchiveEntry.setSize(entryFile.length());
        tarArchiveOutputStream.putArchiveEntry(tarArchiveEntry);
        IOUtils.copy(new FileInputStream(entryFile), (OutputStream)tarArchiveOutputStream);
        tarArchiveOutputStream.closeArchiveEntry();
    }

    private static FileSystem _createFileSystem(Path path, boolean create) throws Exception {
        URI uri = path.toUri();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("create", Boolean.toString(create));
        properties.put("encoding", StandardCharsets.UTF_8.name());
        return FileSystems.newFileSystem(new URI("jar:" + uri.getScheme(), uri.getPath(), null), properties);
    }

    private static Path _stripComponents(Path path, int stripComponents, boolean directory) {
        if (stripComponents > 0) {
            int nameCount = path.getNameCount();
            if (stripComponents < nameCount) {
                return path.subpath(stripComponents, nameCount);
            }
            if (directory && stripComponents == nameCount) {
                return path.relativize(path);
            }
        }
        return path;
    }

    private static void _unsevenZip(Path sevenZipPath, Path destinationDirPath, int stripComponents) throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(sevenZipPath.toFile());){
            SevenZArchiveEntry sevenZArchiveEntry = null;
            while ((sevenZArchiveEntry = sevenZFile.getNextEntry()) != null) {
                Path destinationPath = destinationDirPath.resolve(FileUtil._stripComponents(Paths.get(sevenZArchiveEntry.getName(), new String[0]), stripComponents, sevenZArchiveEntry.isDirectory()));
                if (sevenZArchiveEntry.isDirectory()) {
                    Files.createDirectories(destinationPath, new FileAttribute[0]);
                    continue;
                }
                byte[] content = new byte[(int)sevenZArchiveEntry.getSize()];
                sevenZFile.read(content, 0, content.length);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
                Throwable throwable = null;
                try {
                    FileUtil._writeArchiveEntryFile(sevenZArchiveEntry, destinationPath, byteArrayInputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (byteArrayInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    byteArrayInputStream.close();
                }
            }
        }
    }

    private static void _untar(Path tarPath, Path destinationDirPath, int stripComponents) throws Exception {
        try (InputStream inputStream = Files.newInputStream(tarPath, new OpenOption[0]);
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(new GzipCompressorInputStream(inputStream));){
            TarArchiveEntry tarArchiveEntry = null;
            while ((tarArchiveEntry = tarArchiveInputStream.getNextTarEntry()) != null) {
                Path destinationPath = destinationDirPath.resolve(FileUtil._stripComponents(Paths.get(tarArchiveEntry.getName(), new String[0]), stripComponents, tarArchiveEntry.isDirectory()));
                if (tarArchiveEntry.isDirectory()) {
                    Files.createDirectories(destinationPath, new FileAttribute[0]);
                    continue;
                }
                FileUtil._writeArchiveEntryFile(tarArchiveEntry, destinationPath, tarArchiveInputStream);
            }
        }
    }

    private static void _unzip(Path zipPath, final Path destinationDirPath, final int stripComponents) throws Exception {
        try (FileSystem fileSystem = FileUtil._createFileSystem(zipPath, false);){
            final Path fileSystemPath = fileSystem.getPath("/", new String[0]);
            Files.walkFileTree(fileSystemPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path relativePath = FileUtil._stripComponents(fileSystemPath.relativize(path), stripComponents, true);
                    Path destinationPath = destinationDirPath.resolve(relativePath.toString());
                    Files.createDirectories(destinationPath, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path relativePath = FileUtil._stripComponents(fileSystemPath.relativize(path), stripComponents, false);
                    Path destinationPath = destinationDirPath.resolve(relativePath.toString());
                    FileUtil.copyFile(path, destinationPath);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void _writeArchiveEntryFile(ArchiveEntry archiveEntry, Path destinationPath, InputStream inputStream) throws IOException {
        Path parentPath = destinationPath.getParent();
        if (parentPath != null) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        Files.copy(inputStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        Date lastModifiedDate = archiveEntry.getLastModifiedDate();
        Files.setLastModifiedTime(destinationPath, FileTime.fromMillis(lastModifiedDate.getTime()));
    }
}

