/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.maven;

import com.liferay.portal.tools.bundle.support.commands.InitBundleCommand;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import com.liferay.portal.tools.bundle.support.internal.util.BundleSupportUtil;
import com.liferay.portal.tools.bundle.support.internal.util.MavenUtil;
import com.liferay.portal.tools.bundle.support.maven.AbstractLiferayMojo;
import java.io.File;
import java.net.URL;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;

@Mojo(inheritByDefault=false, name="init")
public class InitBundleMojo
extends AbstractLiferayMojo {
    @Parameter(defaultValue="${user.home}/.liferay/bundles")
    protected File cacheDir;
    @Parameter(defaultValue="configs")
    protected String configs;
    @Parameter(defaultValue="${liferay.workspace.environment}")
    protected String environment;
    @Parameter
    protected String password;
    @Parameter(defaultValue="1")
    protected int stripComponents;
    @Parameter
    protected boolean token;
    @Parameter(defaultValue="${user.home}/.liferay/token")
    protected File tokenFile;
    @Parameter(defaultValue="${liferay.workspace.bundle.url}")
    protected URL url;
    @Parameter
    protected String userName;
    @Parameter(property="session", readonly=true)
    private MavenSession _mavenSession;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        if (this.project.hasParent()) {
            return;
        }
        if (this.environment == null || this.environment.isEmpty()) {
            this.environment = "local";
        }
        if (this.url == null) {
            this.url = BundleSupportConstants.DEFAULT_BUNDLE_URL_OBJECT;
        }
        Proxy proxy = MavenUtil.getProxy(this._mavenSession);
        String proxyProtocol = this.url.getProtocol();
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUser = null;
        String proxyPassword = null;
        String nonProxyHosts = null;
        if (proxy != null) {
            proxyHost = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyHost", proxy.getHost());
            proxyPort = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPort", proxy.getPort());
            proxyUser = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyUser", proxy.getUsername());
            proxyPassword = BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPassword", proxy.getPassword());
            nonProxyHosts = BundleSupportUtil.setSystemProperty(proxyProtocol + ".nonProxyHosts", proxy.getNonProxyHosts());
        }
        try {
            InitBundleCommand initBundleCommand = new InitBundleCommand();
            initBundleCommand.setCacheDir(this.cacheDir);
            initBundleCommand.setConfigsDir(new File(this.project.getBasedir(), this.configs));
            initBundleCommand.setEnvironment(this.environment);
            initBundleCommand.setLiferayHomeDir(this.getLiferayHomeDir());
            initBundleCommand.setPassword(this.password);
            initBundleCommand.setStripComponents(this.stripComponents);
            initBundleCommand.setToken(this.token);
            initBundleCommand.setTokenFile(this.tokenFile);
            initBundleCommand.setUrl(this.url);
            initBundleCommand.setUserName(this.userName);
            initBundleCommand.execute();
            if (proxy == null) return;
        }
        catch (Exception exception) {
            try {
                throw new MojoExecutionException("Unable to initialize bundle", exception);
            }
            catch (Throwable throwable) {
                if (proxy == null) throw throwable;
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyHost", proxyHost);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPort", proxyPort);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyUser", proxyUser);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPassword", proxyPassword);
                BundleSupportUtil.setSystemProperty(proxyProtocol + ".nonProxyHosts", nonProxyHosts);
                throw throwable;
            }
        }
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyHost", proxyHost);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPort", proxyPort);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyUser", proxyUser);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".proxyPassword", proxyPassword);
        BundleSupportUtil.setSystemProperty(proxyProtocol + ".nonProxyHosts", nonProxyHosts);
        return;
    }
}

