/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.liferay.portal.tools.bundle.support.commands.CopyConfigsCommand;
import com.liferay.portal.tools.bundle.support.commands.DownloadCommand;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@Parameters(commandDescription="Download and expand a new bundle.", commandNames={"initBundle"})
public class InitBundleCommand
extends DownloadCommand {
    private static final Set<PosixFilePermission> _shPosixFilePermissions = PosixFilePermissions.fromString("rwxr-x---");
    @Parameter(converter=FileConverter.class, description="The directories that contains the configuration files.", names={"--configs"})
    private List<File> _configsDirs = BundleSupportConstants.defaultConfigsDirs;
    @Parameter(description="The environment of your Liferay home deployment.", names={"--environment"})
    private String _environment = "local";
    @Parameter(converter=FileConverter.class, description="A list of JARs to deploy to \"osgi/modules\".", names={"--provided-modules"})
    private List<File> _providedModules = new ArrayList<File>();
    @Parameter(description="The number of directories to strip when expanding your bundle.", names={"--strip-components"})
    private int _stripComponents = 1;

    @Override
    public void execute() throws Exception {
        this._deleteBundle();
        super.execute();
        File liferayHomeDir = this.getLiferayHomeDir();
        FileUtil.unpack(this.getDownloadPath(), liferayHomeDir.toPath(), this._stripComponents);
        CopyConfigsCommand copyConfigsCommand = new CopyConfigsCommand();
        copyConfigsCommand.setConfigsDirs(this._configsDirs);
        copyConfigsCommand.setEnvironment(this._environment);
        copyConfigsCommand.setLiferayHomeDir(this.getLiferayHomeDir());
        copyConfigsCommand.execute();
        this._copyProvidedModules();
        this._fixPosixFilePermissions();
    }

    public File getConfigsDir() {
        File configsDir = null;
        if (!this._configsDirs.isEmpty()) {
            configsDir = this._configsDirs.get(this._configsDirs.size() - 1);
        }
        return configsDir;
    }

    public List<File> getConfigsDirs() {
        return this._configsDirs;
    }

    public String getEnvironment() {
        return this._environment;
    }

    public List<File> getProvidedModules() {
        return this._providedModules;
    }

    public int getStripComponents() {
        return this._stripComponents;
    }

    public void setConfigsDir(File configsDir) {
        this._configsDirs = Arrays.asList(configsDir);
    }

    public void setConfigsDirs(List<File> configsDirs) {
        this._configsDirs = configsDirs;
    }

    public void setEnvironment(String environment) {
        this._environment = environment;
    }

    public void setProvidedModules(List<File> providedModules) {
        this._providedModules = providedModules;
    }

    public void setStripComponents(int stripComponents) {
        this._stripComponents = stripComponents;
    }

    private void _copyProvidedModules() throws IOException {
        File liferayHomeDir = this.getLiferayHomeDir();
        Path liferayHomeDirPath = liferayHomeDir.toPath();
        Path modulesPath = liferayHomeDirPath.resolve("osgi/modules");
        for (File file : this.getProvidedModules()) {
            Path destinationPath = modulesPath.resolve(file.getName());
            FileUtil.copyFile(file.toPath(), destinationPath);
        }
    }

    private void _deleteBundle() throws IOException {
        File dir = this.getLiferayHomeDir();
        FileUtil.deleteDirectory(dir.toPath());
    }

    private void _fixPosixFilePermissions() throws IOException {
        File dir = this.getLiferayHomeDir();
        Path dirPath = dir.toPath();
        if (!FileUtil.isPosixSupported(dirPath)) {
            return;
        }
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String fileName = String.valueOf(path.getFileName());
                if (fileName.endsWith(".sh")) {
                    Files.setPosixFilePermissions(path, _shPosixFilePermissions);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

