/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import com.liferay.portal.tools.bundle.support.internal.util.HttpUtil;
import com.liferay.portal.tools.bundle.support.util.StreamLogger;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;

@Parameters(commandDescription="Download a file.", commandNames={"download"})
public class DownloadCommand
extends BaseCommand
implements StreamLogger {
    @Parameter(description="The directory where to cache the downloaded bundles.", names={"--cache-dir"})
    private File _cacheDir = new File(System.getProperty("user.home"), ".liferay/bundles");
    private Path _downloadPath;
    @Parameter(description="The password if your URL requires authentication.", names={"-p", "--password"}, password=true)
    private String _password;
    @Parameter(description="Use token authentication.", names={"-t", "--token"})
    private boolean _token;
    @Parameter(description="The file where your liferay.com download token is stored.", names={"--token-file"})
    private File _tokenFile = BundleSupportConstants.DEFAULT_TOKEN_FILE;
    @Parameter(description="The URL of the Liferay Bundle to expand.", names={"--url"})
    private URL _url = BundleSupportConstants.DEFAULT_BUNDLE_URL_OBJECT;
    @Parameter(description="The user name if your URL requires authentication.", names={"-u", "--username", "--user-name"})
    private String _userName;

    @Override
    public void execute() throws Exception {
        URI uri;
        Path cacheDirPath = null;
        if (this._cacheDir != null) {
            cacheDirPath = this._cacheDir.toPath();
        }
        if (Objects.equals((uri = this._url.toURI()).getScheme(), "file")) {
            this._downloadPath = Paths.get(uri);
        } else if (this._token) {
            String tokenContent = FileUtil.read(this._tokenFile);
            tokenContent = tokenContent.trim();
            this._downloadPath = HttpUtil.downloadFile(uri, tokenContent, cacheDirPath, this);
        } else {
            this._downloadPath = HttpUtil.downloadFile(uri, this._userName, this._password, cacheDirPath, this);
        }
    }

    public File getCacheDir() {
        return this._cacheDir;
    }

    public Path getDownloadPath() {
        return this._downloadPath;
    }

    public String getPassword() {
        return this._password;
    }

    public File getTokenFile() {
        return this._tokenFile;
    }

    public URL getUrl() {
        return this._url;
    }

    public String getUserName() {
        return this._userName;
    }

    public boolean isToken() {
        return this._token;
    }

    @Override
    public void onCompleted() {
        System.out.println();
    }

    @Override
    public void onProgress(long completed, long length) {
        StringBuilder sb = new StringBuilder();
        sb.append(FileUtil.getFileLength(completed));
        if (length > 0L) {
            sb.append('/');
            sb.append(FileUtil.getFileLength(length));
        }
        sb.append(" downloaded");
        this.onProgress(sb.toString());
    }

    @Override
    public void onStarted() {
        this.onStarted("Download " + this._url);
    }

    public void setCacheDir(File cacheDir) {
        this._cacheDir = cacheDir;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setToken(boolean token) {
        this._token = token;
    }

    public void setTokenFile(File tokenFile) {
        this._tokenFile = tokenFile;
    }

    public void setUrl(URL url) {
        this._url = url;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    protected void onProgress(String message) {
        char[] chars = new char[80];
        System.arraycopy(message.toCharArray(), 0, chars, 0, message.length());
        Arrays.fill(chars, message.length(), chars.length - 2, ' ');
        chars[chars.length - 1] = 13;
        System.out.print(chars);
    }

    protected void onStarted(String message) {
        System.out.println(message);
    }
}

