/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.liferay.portal.tools.bundle.support.commands.BaseCommand;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

@Parameters(commandDescription="Copy the configs of an environment to the bundle.", commandNames={"copyConfigs"})
public class CopyConfigsCommand
extends BaseCommand {
    @Parameter(converter=FileConverter.class, description="The directories that contains the configuration files.", names={"--configs"})
    private List<File> _configsDirs = BundleSupportConstants.defaultConfigsDirs;
    @Parameter(description="The environment of your Liferay home deployment.", names={"--environment"})
    private String _environment = "local";

    @Override
    public void execute() throws Exception {
        for (File configsDir : this._configsDirs) {
            this._copyConfigs(configsDir);
        }
    }

    public List<File> getConfigsDirs() {
        return this._configsDirs;
    }

    public String getEnvironment() {
        return this._environment;
    }

    public void setConfigsDirs(List<File> configsDirs) {
        this._configsDirs = configsDirs;
    }

    public void setEnvironment(String environment) {
        this._environment = environment;
    }

    private void _copyConfigs(File configsDir) throws IOException {
        Path configsEnvironmentDirPath;
        if (configsDir == null || !configsDir.exists()) {
            return;
        }
        Path configsDirPath = configsDir.toPath();
        Path configsCommonDirPath = configsDirPath.resolve("common");
        File liferayHomeDir = this.getLiferayHomeDir();
        Path liferayHomeDirPath = liferayHomeDir.toPath();
        if (Files.exists(configsCommonDirPath, new LinkOption[0])) {
            FileUtil.copyDirectory(configsCommonDirPath, liferayHomeDirPath);
        }
        if (Files.exists(configsEnvironmentDirPath = configsDirPath.resolve(this._environment), new LinkOption[0])) {
            FileUtil.copyDirectory(configsEnvironmentDirPath, liferayHomeDirPath);
        }
    }
}

