/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.DownloadCommand;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

@Parameters(commandDescription="Download and expand a new bundle.", commandNames={"initBundle"})
public class InitBundleCommand
extends DownloadCommand {
    private static final Set<PosixFilePermission> _shPosixFilePermissions = PosixFilePermissions.fromString("rwxr-x---");
    @Parameter(description="The directory that contains the configuration files.", names={"--configs"})
    private File _configsDir;
    @Parameter(description="The environment of your Liferay home deployment.", names={"--environment"})
    private String _environment = "local";
    @Parameter(description="The number of directories to strip when expanding your bundle.", names={"--strip-components"})
    private int _stripComponents = 1;

    @Override
    public void execute() throws Exception {
        this._deleteBundle();
        super.execute();
        File liferayHomeDir = this.getLiferayHomeDir();
        FileUtil.unpack(this.getDownloadPath(), liferayHomeDir.toPath(), this._stripComponents);
        this._copyConfigs();
        this._fixPosixFilePermissions();
    }

    public File getConfigsDir() {
        return this._configsDir;
    }

    public String getEnvironment() {
        return this._environment;
    }

    public int getStripComponents() {
        return this._stripComponents;
    }

    public void setConfigsDir(File configsDir) {
        this._configsDir = configsDir;
    }

    public void setEnvironment(String environment) {
        this._environment = environment;
    }

    public void setStripComponents(int stripComponents) {
        this._stripComponents = stripComponents;
    }

    private void _copyConfigs() throws IOException {
        Path configsEnvironmentDirPath;
        if (this._configsDir == null || !this._configsDir.exists()) {
            return;
        }
        Path configsDirPath = this._configsDir.toPath();
        Path configsCommonDirPath = configsDirPath.resolve("common");
        File liferayHomeDir = this.getLiferayHomeDir();
        Path liferayHomeDirPath = liferayHomeDir.toPath();
        if (Files.exists(configsCommonDirPath, new LinkOption[0])) {
            FileUtil.copyDirectory(configsCommonDirPath, liferayHomeDirPath);
        }
        if (Files.exists(configsEnvironmentDirPath = configsDirPath.resolve(this._environment), new LinkOption[0])) {
            FileUtil.copyDirectory(configsEnvironmentDirPath, liferayHomeDirPath);
        }
    }

    private void _deleteBundle() throws IOException {
        File dir = this.getLiferayHomeDir();
        FileUtil.deleteDirectory(dir.toPath());
    }

    private void _fixPosixFilePermissions() throws IOException {
        File dir = this.getLiferayHomeDir();
        Path dirPath = dir.toPath();
        if (!FileUtil.isPosixSupported(dirPath)) {
            return;
        }
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String fileName = String.valueOf(path.getFileName());
                if (fileName.endsWith(".sh")) {
                    Files.setPosixFilePermissions(path, _shPosixFilePermissions);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

