/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tika.internal.mime;

import com.liferay.petra.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReaderMetKeys;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component(service={com.liferay.portal.kernel.util.MimeTypes.class})
public class MimeTypesImpl
implements com.liferay.portal.kernel.util.MimeTypes,
MimeTypesReaderMetKeys {
    private static final Log _log = LogFactoryUtil.getLog(MimeTypesImpl.class);
    private final Map<String, String> _contentTypes = new HashMap<String, String>();
    private final Detector _detector = new DefaultDetector();
    private final Map<String, Set<String>> _extensionsMap = new HashMap<String, Set<String>>();

    public String getContentType(File file) {
        return this.getContentType(file, file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContentType(File file, String fileName) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = this.getContentType(inputStream, fileName);
            return string;
        }
        catch (Exception exception) {
            if (!_log.isWarnEnabled()) return this.getContentType(fileName);
            _log.warn((Throwable)exception);
            return this.getContentType(fileName);
        }
    }

    public String getContentType(InputStream inputStream, String fileName) {
        String extension = this._getExtension(fileName);
        String contentType = this._contentTypes.get(extension);
        if (contentType != null) {
            return contentType;
        }
        Metadata metadata = new Metadata();
        if (Validator.isNotNull((String)fileName)) {
            metadata.set("resourceName", HtmlUtil.escapeURL((String)fileName));
        }
        if (inputStream != null && !inputStream.markSupported()) {
            inputStream = new UnsyncBufferedInputStream(inputStream);
        }
        try {
            contentType = String.valueOf(this._detector.detect(inputStream, metadata));
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        if (inputStream != null) {
            return contentType;
        }
        Set<String> extensions = this._extensionsMap.get("application/octet-stream");
        if (!extensions.contains(extension) && Objects.equals(contentType, "application/octet-stream")) {
            return null;
        }
        return contentType;
    }

    public String getContentType(String fileName) {
        return this.getContentType((InputStream)null, fileName);
    }

    public String getExtensionContentType(String extension) {
        if (Validator.isNull((String)extension)) {
            return "application/octet-stream";
        }
        return this.getContentType("A.".concat(extension));
    }

    public Set<String> getExtensions(String contentType) {
        Set<String> extensions = this._extensionsMap.get(contentType);
        if (extensions == null) {
            extensions = Collections.emptySet();
        }
        return extensions;
    }

    @Activate
    protected void activate() throws Exception {
        this.read(MimeTypes.class.getResourceAsStream("tika-mimetypes.xml"), this._extensionsMap);
        HashMap<String, Set<String>> extensionsMap = new HashMap<String, Set<String>>();
        this.read(MimeTypesImpl.class.getResourceAsStream("dependencies/custom-mimetypes.xml"), extensionsMap);
        for (Map.Entry entry : extensionsMap.entrySet()) {
            for (String extension : (Set)entry.getValue()) {
                this._contentTypes.put(extension, (String)entry.getKey());
            }
        }
    }

    protected void read(InputStream inputStream, Map<String, Set<String>> extensionsMap) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(inputStream));
        Element element = document.getDocumentElement();
        if (element == null || !"mime-info".equals(element.getTagName())) {
            throw new SystemException("Invalid configuration file");
        }
        NodeList nodeList = element.getElementsByTagName("mime-type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.readMimeType((Element)nodeList.item(i), extensionsMap);
        }
    }

    protected void readMimeType(Element element, Map<String, Set<String>> extensionsMap) {
        Set<String> extensions = new HashSet();
        NodeList globNodeList = element.getElementsByTagName("glob");
        for (int i = 0; i < globNodeList.getLength(); ++i) {
            String extension;
            String pattern;
            Element globElement = (Element)globNodeList.item(i);
            boolean regex = GetterUtil.getBoolean((String)globElement.getAttribute("isregex"));
            if (regex || !(pattern = globElement.getAttribute("pattern")).startsWith("*") || (extension = pattern.substring(1)).contains("*") || extension.contains("?") || extension.contains("[")) continue;
            extensions.add(extension);
        }
        if (extensions.isEmpty()) {
            return;
        }
        if (extensions.size() == 1) {
            Iterator iterator = extensions.iterator();
            extensions = Collections.singleton(iterator.next());
        }
        extensionsMap.put(element.getAttribute("type"), extensions);
        NodeList aliasNodeList = element.getElementsByTagName("alias");
        for (int i = 0; i < aliasNodeList.getLength(); ++i) {
            Element aliasElement = (Element)aliasNodeList.item(i);
            extensionsMap.put(aliasElement.getAttribute("type"), extensions);
        }
    }

    private String _getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return StringUtil.toLowerCase((String)fileName.substring(pos));
        }
        return null;
    }
}

