/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.renderer.internal.helper;

import com.liferay.frontend.js.module.launcher.JSModuleDependency;
import com.liferay.frontend.js.module.launcher.JSModuleLauncher;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.kernel.servlet.taglib.aui.VariableUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.soy.renderer.ComponentDescriptor;
import com.liferay.portal.template.soy.renderer.SoyRenderer;
import com.liferay.portal.template.soy.renderer.internal.SoyJavaScriptRendererUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SoyComponentRendererHelper {
    private static final char[] _UNSAFE_MODULE_NAME_CHARS = new char[]{'.', '-'};
    private final ComponentDescriptor _componentDescriptor;
    private final Map<String, Object> _context;
    private final String _elementSelector;
    private final HttpServletRequest _httpServletRequest;
    private final JSModuleLauncher _jsModuleLauncher;
    private final String _moduleName;
    private final Portal _portal;
    private final SoyRenderer _soyRenderer;
    private final String _wrapperId;

    public SoyComponentRendererHelper(HttpServletRequest httpServletRequest, ComponentDescriptor componentDescriptor, Map<String, ?> context, JSModuleLauncher jsModuleLauncher, Portal portal, SoyRenderer soyRenderer) {
        this._httpServletRequest = httpServletRequest;
        this._componentDescriptor = componentDescriptor;
        this._context = new HashMap(context);
        this._jsModuleLauncher = jsModuleLauncher;
        this._portal = portal;
        this._soyRenderer = soyRenderer;
        this._moduleName = this._getModuleName(this._componentDescriptor.getModule());
        this._wrapperId = this._generateWrapperId((String)this._context.get("id"), this._componentDescriptor.getComponentId());
        this._elementSelector = this._getElementSelector(this._wrapperId, this._componentDescriptor.isWrapper());
        this._prepareContext();
    }

    public void renderSoyComponent(Writer writer) throws IOException, TemplateException {
        this._renderTemplate(writer);
        if (this._componentDescriptor.isRenderJavascript()) {
            this._renderJavaScript(writer);
        }
    }

    private String _generateWrapperId(String id, String componentId) {
        String wrapperId = id;
        if (Validator.isNull((String)wrapperId) && Validator.isNull((String)(wrapperId = componentId))) {
            wrapperId = StringUtil.randomId();
        }
        return wrapperId;
    }

    private String _getElementSelector(String wrapperId, boolean wrapper) {
        String selector = "#".concat(wrapperId);
        if (wrapper) {
            selector = selector.concat(" > *:first-child");
        }
        return selector;
    }

    private String _getModuleName(String module) {
        String moduleName = StringUtil.extractLast((String)module, (char)'/');
        return StringUtil.removeChars((String)moduleName, (char[])_UNSAFE_MODULE_NAME_CHARS);
    }

    private void _prepareContext() {
        if (!this._context.containsKey("locale")) {
            this._context.put("locale", LocaleUtil.getMostRelevantLocale());
        }
        if (!this._context.containsKey("portletId")) {
            this._context.put("portletId", this._httpServletRequest.getAttribute("PORTLET_ID"));
        }
        if (!this._componentDescriptor.isWrapper() && Validator.isNull((Object)this._context.get("id"))) {
            this._context.put("id", this._wrapperId);
        }
        if (this._componentDescriptor.isRenderJavascript() && !this._context.containsKey("element")) {
            this._context.put("element", this._elementSelector);
        }
    }

    private void _renderJavaScript(Writer writer) throws IOException {
        String componentJavaScript = SoyJavaScriptRendererUtil.getJavaScript(this._context, this._wrapperId, this._moduleName, this._componentDescriptor.isWrapper());
        if (this._jsModuleLauncher.isValidModule(this._componentDescriptor.getModule())) {
            ArrayList<JSModuleDependency> jsModuleDependencies = new ArrayList<JSModuleDependency>();
            jsModuleDependencies.add(new JSModuleDependency(this._componentDescriptor.getModule(), this._moduleName));
            HashSet usedVariables = new HashSet();
            for (String dependency : this._componentDescriptor.getDependencies()) {
                jsModuleDependencies.add(new JSModuleDependency(dependency, VariableUtil.generateVariable((String)dependency, usedVariables)));
            }
            if (this._componentDescriptor.isPositionInLine()) {
                this._jsModuleLauncher.writeScript(writer, jsModuleDependencies, componentJavaScript);
            } else {
                this._jsModuleLauncher.appendPortletScript(this._httpServletRequest, this._portal.getPortletId(this._httpServletRequest), jsModuleDependencies, componentJavaScript);
            }
        } else {
            StringBundler sb = new StringBundler(5);
            sb.append(this._componentDescriptor.getModule());
            sb.append(" as ");
            sb.append(this._moduleName);
            Set dependencies = this._componentDescriptor.getDependencies();
            if (!dependencies.isEmpty()) {
                sb.append(",");
            }
            sb.append(StringUtil.merge((Collection)dependencies));
            if (this._componentDescriptor.isPositionInLine()) {
                ScriptData scriptData = new ScriptData();
                scriptData.append(this._portal.getPortletId(this._httpServletRequest), componentJavaScript, sb.toString(), ScriptData.ModulesType.ES6);
                scriptData.writeTo(writer);
            } else {
                ScriptData scriptData = (ScriptData)this._httpServletRequest.getAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA");
                if (scriptData == null) {
                    scriptData = new ScriptData();
                    this._httpServletRequest.setAttribute("LIFERAY_SHARED_AUI_SCRIPT_DATA", (Object)scriptData);
                }
                scriptData.append(this._portal.getPortletId(this._httpServletRequest), componentJavaScript, sb.toString(), ScriptData.ModulesType.ES6);
            }
        }
    }

    private void _renderTemplate(Writer writer) throws IOException, TemplateException {
        String placeholder;
        boolean wrapper = this._componentDescriptor.isWrapper();
        if (wrapper) {
            writer.append("<div id=\"");
            writer.append(HtmlUtil.escapeAttribute((String)this._wrapperId));
            writer.append("\">");
        }
        if (Validator.isNotNull((String)(placeholder = (String)this._context.get("__placeholder__")))) {
            writer.append(placeholder);
        } else {
            writer.append("<div id=\"");
            writer.append((String)this._context.get("id"));
            writer.append("\"></div>");
        }
        if (wrapper) {
            writer.append("</div>");
        }
    }
}

