/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.renderer.internal;

import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.soy.SoyTemplateResourceFactory;
import com.liferay.portal.template.soy.renderer.SoyRenderer;
import com.liferay.portal.template.soy.util.SoyTemplateResourcesProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={SoyRenderer.class})
public class SoyRendererImpl
implements SoyRenderer {
    @Reference
    private SoyTemplateResourceFactory _soyTemplateResourceFactory;
    @Reference
    private SoyTemplateResourcesProvider _soyTemplateResourcesProvider;
    private volatile TemplateManager _templateManager;

    public void renderSoy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String templateNamespace, Map<String, ?> context) throws IOException, TemplateException {
        this.renderSoy(httpServletRequest, httpServletResponse.getWriter(), templateNamespace, context);
    }

    public void renderSoy(HttpServletRequest httpServletRequest, Writer writer, String templateNamespace, Map<String, ?> context) throws TemplateException {
        Template template = this._getTemplate();
        template.putAll(context);
        template.put((Object)"namespace", (Object)templateNamespace);
        template.prepare(httpServletRequest);
        template.processTemplate(writer);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addTemplateManager(TemplateManager templateManager) {
        String templateManagerName = templateManager.getName();
        if (templateManagerName.equals("soy")) {
            this._templateManager = templateManager;
        }
    }

    protected void removeTemplateManager(TemplateManager templateManager) {
        String templateManagerName = templateManager.getName();
        if (templateManagerName.equals("soy")) {
            this._templateManager = null;
        }
    }

    private Template _getTemplate() throws TemplateException {
        if (this._templateManager == null) {
            throw new TemplateException("Unable to find the Soy template manager");
        }
        return this._templateManager.getTemplate((TemplateResource)this._soyTemplateResourceFactory.createSoyTemplateResource(this._soyTemplateResourcesProvider.getAllTemplateResources()), false);
    }
}

