/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.renderer.internal;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.util.Map;

public class SoyJavaScriptRendererUtil {
    private static final String _JAVA_SCRIPT_TPL;
    private static final Log _log;

    public static String getJavaScript(Map<String, Object> context, String id, String module) {
        return SoyJavaScriptRendererUtil.getJavaScript(context, id, module, true);
    }

    public static String getJavaScript(Map<String, Object> context, String id, String module, boolean wrapper) {
        JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
        String contextString = jsonSerializer.serializeDeep(context);
        String wrapperString = jsonSerializer.serialize((Object)wrapper);
        return StringUtil.replace((String)_JAVA_SCRIPT_TPL, (String[])new String[]{"$CONTEXT", "$ID", "$MODULE", "$WRAPPER"}, (String[])new String[]{contextString, id, module, wrapperString});
    }

    static {
        _log = LogFactoryUtil.getLog(SoyJavaScriptRendererUtil.class);
        InputStream inputStream = SoyJavaScriptRendererUtil.class.getResourceAsStream("dependencies/bootstrap.js.tpl");
        String js = "";
        try {
            js = StringUtil.read((InputStream)inputStream);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to read template", (Throwable)e);
        }
        _JAVA_SCRIPT_TPL = js;
    }
}

