/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.soy.SoyTemplateResource;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.util.List;

public class SoyTemplateResourceImpl
implements SoyTemplateResource {
    private volatile String _templateId;
    private final List<TemplateResource> _templateResources;

    public SoyTemplateResourceImpl(List<TemplateResource> templateResources) {
        this._templateResources = templateResources;
    }

    public long getLastModified() {
        throw new UnsupportedOperationException("Soy template resource does not support this method");
    }

    public Reader getReader() {
        throw new UnsupportedOperationException("Soy template resource does not support this method");
    }

    public String getTemplateId() {
        String templateId = this._templateId;
        if (templateId != null) {
            return templateId;
        }
        StringBundler sb = new StringBundler(this._templateResources.size() * 2 - 1);
        for (TemplateResource templateResource : this._templateResources) {
            if (sb.index() > 0) {
                sb.append(",");
            }
            sb.append(templateResource.getTemplateId());
        }
        this._templateId = templateId = sb.toString();
        return templateId;
    }

    public List<TemplateResource> getTemplateResources() {
        return this._templateResources;
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        for (TemplateResource templateResource : this._templateResources) {
            templateResource.readExternal(objectInput);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        for (TemplateResource templateResource : this._templateResources) {
            templateResource.writeExternal(objectOutput);
        }
    }
}

