/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.template.soy.internal.util.SoyTemplateUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;

@Component(service={SoyProviderCapabilityBundleRegister.class})
public class SoyProviderCapabilityBundleRegister {
    private static final Log _log = LogFactoryUtil.getLog(SoyProviderCapabilityBundleRegister.class);
    private static final Map<Long, Bundle> _bundles = new ConcurrentHashMap<Long, Bundle>();

    public static Bundle getTemplateBundle(String templateId) {
        Bundle bundle = _bundles.get(SoyTemplateUtil.getBundleId(templateId));
        if (bundle == null) {
            Collection<Bundle> bundles = _bundles.values();
            StringBundler sb = new StringBundler(bundles.size() * 2);
            for (Bundle registredBundle : _bundles.values()) {
                sb.append(registredBundle.getSymbolicName());
                sb.append(", ");
            }
            _log.error((Object)String.format("Registred bundles %s", sb.toString()));
            throw new IllegalStateException("There are no bundles providing " + templateId);
        }
        return bundle;
    }

    public void register(Bundle bundle) {
        _bundles.put(bundle.getBundleId(), bundle);
    }

    public void unregister(Bundle bundle) {
        _bundles.remove(bundle.getBundleId());
    }
}

