/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.soy.internal.SoyManager;
import com.liferay.portal.template.soy.internal.util.SoyTemplateResourcesCollector;
import com.liferay.portal.template.soy.util.SoyTemplateResourcesProvider;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SoyTemplateResourcesProvider.class})
public class SoyTemplateResourcesProviderImpl
implements SoyTemplateResourcesProvider {
    private static final Log _log = LogFactoryUtil.getLog(SoyTemplateResourcesProviderImpl.class);
    private static SoyManager _soyManager;

    public List<TemplateResource> getAllTemplateResources() {
        if (_soyManager == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(_soyManager.getAllTemplateResources());
    }

    public List<TemplateResource> getBundleTemplateResources(Bundle bundle, String templatePath) {
        try {
            SoyTemplateResourcesCollector soyTemplateResourcesCollector = new SoyTemplateResourcesCollector(bundle, templatePath);
            return soyTemplateResourcesCollector.getTemplateResources();
        }
        catch (TemplateException te) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get template resources for bundle " + bundle.getBundleId()), (Throwable)te);
            }
            return Collections.emptyList();
        }
    }

    @Reference(unbind="-")
    protected void setSoyManager(SoyManager soyManager) {
        _soyManager = soyManager;
    }
}

