/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.template.URLTemplateResource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class SoyTemplateResourcesCollector {
    private static final String _SOY_FILE_EXTENSION = "*.soy";
    private static final Log _log = LogFactoryUtil.getLog(SoyTemplateResourcesCollector.class);
    private final Bundle _bundle;
    private final String _templatePath;

    public SoyTemplateResourcesCollector(Bundle bundle, String templatePath) {
        this._bundle = bundle;
        this._templatePath = templatePath;
    }

    public List<TemplateResource> getTemplateResources() throws TemplateException {
        ArrayList<TemplateResource> templateResources = new ArrayList<TemplateResource>();
        this.collectBundleTemplateResources(templateResources);
        this.collectProviderBundlesTemplateResources(templateResources);
        return templateResources;
    }

    protected void collectBundleTemplateResources(Bundle bundle, List<TemplateResource> templateResources) {
        List<URL> urls = this.getSoyResourceURLs(bundle, this._templatePath);
        for (URL url : urls) {
            String templateId = this.getTemplateId(bundle.getBundleId(), url);
            try {
                TemplateResource templateResource = this._getTemplateResource(templateId, url);
                templateResources.add(templateResource);
            }
            catch (TemplateException te) {
                throw new IllegalStateException("Unable to collect template reosurces for bundle " + bundle.getBundleId(), te);
            }
        }
    }

    protected void collectBundleTemplateResources(List<TemplateResource> templateResources) {
        this.collectBundleTemplateResources(this._bundle, templateResources);
    }

    protected void collectProviderBundlesTemplateResources(List<TemplateResource> templateResources) throws TemplateException {
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        for (BundleWire bundleWire : bundleWiring.getRequiredWires("soy")) {
            Bundle providerBundle = this.getProviderBundle(bundleWire);
            List<URL> urls = this.getSoyResourceURLs(providerBundle, "/");
            for (URL url : urls) {
                String templateId = this.getTemplateId(providerBundle.getBundleId(), url);
                TemplateResource templateResource = null;
                try {
                    templateResource = this._getTemplateResource(templateId, url);
                }
                catch (IllegalStateException ise) {
                    _log.error((Object)String.format("{providerBundle=%s, templateId=%s}", providerBundle.getSymbolicName(), templateId));
                    throw ise;
                }
                templateResources.add(templateResource);
            }
        }
    }

    protected Bundle getProviderBundle(BundleWire bundleWire) {
        BundleRevision bundleRevision = bundleWire.getProvider();
        return bundleRevision.getBundle();
    }

    protected List<URL> getSoyResourceURLs(Bundle bundle, String templatePath) {
        int bundleState = bundle.getState();
        if (bundleState == 1) {
            return Collections.emptyList();
        }
        Enumeration urls = bundle.findEntries(templatePath, _SOY_FILE_EXTENSION, true);
        if (urls == null) {
            return Collections.emptyList();
        }
        return Collections.list(urls);
    }

    protected String getTemplateId(long bundleId, URL url) {
        return String.valueOf(bundleId).concat("_BUNDLE_CONTEXT_").concat(url.getPath());
    }

    private TemplateResource _getTemplateResource(String templateId, URL url) throws TemplateException {
        Object templateResource = TemplateResourceLoaderUtil.hasTemplateResourceLoader((String)"soy") ? TemplateResourceLoaderUtil.getTemplateResource((String)"soy", (String)templateId) : new URLTemplateResource(templateId, url);
        return templateResource;
    }
}

