/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.google.template.soy.SoyFileSet;
import com.google.template.soy.tofu.SoyTofu;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.soy.internal.SoyTofuCacheBag;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;

public class SoyTofuCacheHandler {
    private final PortalCache<HashSet<TemplateResource>, SoyTofuCacheBag> _portalCache;

    public SoyTofuCacheHandler(PortalCache<HashSet<TemplateResource>, SoyTofuCacheBag> portalCache) {
        this._portalCache = portalCache;
    }

    public SoyTofuCacheBag add(List<TemplateResource> templateResources, SoyFileSet soyFileSet, SoyTofu soyTofu) {
        HashSet<TemplateResource> key = this.getKeySet(templateResources);
        SoyTofuCacheBag soyTofuCacheBag = new SoyTofuCacheBag(soyFileSet, soyTofu);
        this._portalCache.put(key, (Object)soyTofuCacheBag);
        return soyTofuCacheBag;
    }

    public SoyTofuCacheBag get(List<TemplateResource> templateResources) {
        HashSet<TemplateResource> key = this.getKeySet(templateResources);
        return (SoyTofuCacheBag)this._portalCache.get(key);
    }

    public SoyTofu getSoyTofu(List<TemplateResource> templateResources) {
        SoyTofuCacheBag soyTofuCacheBag = this.get(templateResources);
        return soyTofuCacheBag.getSoyTofu();
    }

    public void removeIfAny(List<TemplateResource> templateResources) {
        for (TemplateResource templateResource : templateResources) {
            for (HashSet key : this._portalCache.getKeys()) {
                if (!key.contains(templateResource)) continue;
                this._portalCache.remove((Serializable)key);
            }
        }
    }

    protected HashSet<TemplateResource> getKeySet(List<TemplateResource> templateResources) {
        return new HashSet<TemplateResource>(templateResources);
    }
}

