/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.google.common.io.CharStreams;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.tofu.SoyTofu;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.BaseTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.soy.SoyTemplateResource;
import com.liferay.portal.template.soy.internal.SoyContextImpl;
import com.liferay.portal.template.soy.internal.SoyMsgBundleBridge;
import com.liferay.portal.template.soy.internal.SoyProviderCapabilityBundleRegister;
import com.liferay.portal.template.soy.internal.SoyTemplateContextHelper;
import com.liferay.portal.template.soy.internal.SoyTofuCacheBag;
import com.liferay.portal.template.soy.internal.SoyTofuCacheHandler;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class SoyTemplate
extends BaseTemplate {
    private static final Log _log = LogFactoryUtil.getLog(SoyTemplate.class);
    private final SoyContextImpl _soyContextImpl;
    private final SoyTofuCacheHandler _soyTofuCacheHandler;
    private final SoyTemplateContextHelper _templateContextHelper;

    public SoyTemplate(SoyTemplateResource soyTemplateResource, Map<String, Object> context, SoyTemplateContextHelper templateContextHelper, SoyTofuCacheHandler soyTofuCacheHandler) {
        super((TemplateResource)soyTemplateResource, null, (TemplateContextHelper)templateContextHelper);
        if (ListUtil.isEmpty((List)soyTemplateResource.getTemplateResources())) {
            throw new IllegalArgumentException("Template resource is null");
        }
        this._templateContextHelper = templateContextHelper;
        this._soyContextImpl = new SoyContextImpl(context, templateContextHelper.getRestrictedVariables());
        this._soyTofuCacheHandler = soyTofuCacheHandler;
        this._setBaseContext();
    }

    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingBiFunction) {
        return this._soyContextImpl.compute(key, remappingBiFunction);
    }

    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        return this._soyContextImpl.computeIfAbsent(key, mappingFunction);
    }

    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingBiFunction) {
        return this._soyContextImpl.computeIfPresent(key, remappingBiFunction);
    }

    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this._soyContextImpl.forEach(action);
    }

    public Object getOrDefault(Object key, Object defaultValue) {
        return this._soyContextImpl.getOrDefault(key, defaultValue);
    }

    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingBiFunction) {
        return this._soyContextImpl.merge(key, value, remappingBiFunction);
    }

    public void prepare(HttpServletRequest httpServletRequest) {
        HashMap<String, Object> injectedDataObjects = new HashMap<String, Object>();
        this._templateContextHelper.prepare(injectedDataObjects, httpServletRequest);
        for (Map.Entry entry : injectedDataObjects.entrySet()) {
            this._soyContextImpl.putInjectedData((String)entry.getKey(), entry.getValue());
        }
    }

    public Object putIfAbsent(String key, Object value) {
        return this._soyContextImpl.putIfAbsent(key, value);
    }

    public boolean remove(Object key, Object value) {
        return this._soyContextImpl.remove(key, value);
    }

    public Object replace(String key, Object value) {
        return this._soyContextImpl.replace(key, value);
    }

    public boolean replace(String key, Object oldValue, Object newValue) {
        return this._soyContextImpl.replace(key, oldValue, newValue);
    }

    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        this._soyContextImpl.replaceAll(function);
    }

    protected SoyMsgBundleBridge createSoyMsgBundleBridge(List<TemplateResource> templateResources, SoyFileSet soyFileSet, Locale locale) {
        SoyMsgBundle soyMsgBundle = soyFileSet.extractMsgs();
        ResourceBundle languageResourceBundle = this._getLanguageResourceBundle(templateResources, locale);
        return new SoyMsgBundleBridge(soyMsgBundle, locale, languageResourceBundle);
    }

    protected SoyFileSet getSoyFileSet(List<TemplateResource> templateResources) throws Exception {
        SoyFileSet.Builder builder = SoyFileSet.builder();
        HashSet<String> templateIds = new HashSet<String>();
        for (TemplateResource templateResource : templateResources) {
            if (templateIds.contains(templateResource.getTemplateId())) continue;
            templateIds.add(templateResource.getTemplateId());
            String templateContent = this.getTemplateContent(templateResource);
            builder.add((CharSequence)templateContent, templateResource.getTemplateId());
        }
        return builder.build();
    }

    protected Optional<SoyMsgBundle> getSoyMsgBundle(List<TemplateResource> templateResources, SoyFileSet soyFileSet, SoyTofuCacheBag soyTofuCacheBag) {
        Locale locale = (Locale)this.get("locale");
        if (locale != null) {
            SoyMsgBundle soyMsgBundle = soyTofuCacheBag.getMessageBundle(locale);
            if (soyMsgBundle == null) {
                soyMsgBundle = this.createSoyMsgBundleBridge(templateResources, soyFileSet, locale);
                soyTofuCacheBag.putMessageBundle(locale, soyMsgBundle);
            }
            return Optional.of(soyMsgBundle);
        }
        return Optional.empty();
    }

    protected SoyTofuCacheBag getSoyTofuCacheBag(List<TemplateResource> templateResources) throws Exception {
        SoyTofuCacheBag soyTofuCacheBag = this._soyTofuCacheHandler.get(templateResources);
        if (soyTofuCacheBag == null) {
            SoyFileSet soyFileSet = this.getSoyFileSet(templateResources);
            SoyTofu soyTofu = soyFileSet.compileToTofu();
            soyTofuCacheBag = this._soyTofuCacheHandler.add(templateResources, soyFileSet, soyTofu);
        }
        return soyTofuCacheBag;
    }

    protected String getTemplateContent(TemplateResource templateResource) throws Exception {
        Reader reader = templateResource.getReader();
        return CharStreams.toString((Readable)reader);
    }

    protected void handleException(TemplateResource templateResource, TemplateResource errorTemplateResource, Exception exception, Writer writer) throws TemplateException {
        this.put("exception", exception.getMessage());
        SoyTemplateResource soyTemplateResource = (SoyTemplateResource)templateResource;
        StringBundler sb = new StringBundler();
        for (TemplateResource innerTemplateResource : soyTemplateResource.getTemplateResources()) {
            if (!(innerTemplateResource instanceof StringTemplateResource)) continue;
            StringTemplateResource stringTemplateResource = (StringTemplateResource)innerTemplateResource;
            sb.append(stringTemplateResource.getContent());
        }
        this.put("script", sb.toString());
        try {
            this.processTemplate(errorTemplateResource, writer);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to process Soy template " + errorTemplateResource.getTemplateId(), (Throwable)e);
        }
    }

    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        boolean renderStrict;
        List templateResources;
        String namespace = GetterUtil.getString((Object)this.get("namespace"));
        if (Validator.isNull((String)namespace)) {
            throw new TemplateException("Namespace is not specified");
        }
        if (templateResource instanceof SoyTemplateResource) {
            SoyTemplateResource soyTemplateResource = (SoyTemplateResource)templateResource;
            templateResources = soyTemplateResource.getTemplateResources();
        } else {
            templateResources = Collections.singletonList(templateResource);
        }
        SoyTofuCacheBag soyTofuCacheBag = this.getSoyTofuCacheBag(templateResources);
        SoyTofu soyTofu = soyTofuCacheBag.getSoyTofu();
        SoyTofu.Renderer renderer = soyTofu.newRenderer(namespace);
        renderer.setData((SoyRecord)this._soyContextImpl.createSoyTemplateRecord());
        renderer.setIjData((SoyRecord)this._soyContextImpl.createInjectedSoyTemplateRecord());
        SoyFileSet soyFileSet = soyTofuCacheBag.getSoyFileSet();
        Optional<SoyMsgBundle> soyMsgBundle = this.getSoyMsgBundle(templateResources, soyFileSet, soyTofuCacheBag);
        if (soyMsgBundle.isPresent()) {
            renderer.setMsgBundle(soyMsgBundle.get());
        }
        if (renderStrict = GetterUtil.getBoolean((Object)this.get("render_strict"), (boolean)true)) {
            SanitizedContent sanitizedContent = renderer.renderStrict();
            writer.write(sanitizedContent.stringValue());
        } else {
            writer.write(renderer.render());
        }
    }

    private ResourceBundle _getLanguageResourceBundle(List<TemplateResource> templateResources, Locale locale) {
        HashSet<Bundle> templateResourceBundles = new HashSet<Bundle>();
        for (TemplateResource templateResource : templateResources) {
            try {
                Bundle templateResourceBundle = SoyProviderCapabilityBundleRegister.getTemplateBundle(templateResource.getTemplateId());
                templateResourceBundles.add(templateResourceBundle);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                String templateId = templateResource.getTemplateId();
                _log.debug((Object)("Unable to get language resource bundle for template " + StringUtil.quote((String)templateId)), (Throwable)e);
            }
        }
        ArrayList<Object> resourceBundleLoaders = new ArrayList<Object>(templateResourceBundles.size() + 1);
        for (Bundle templateResourceBundle : templateResourceBundles) {
            BundleWiring bundleWiring = (BundleWiring)templateResourceBundle.adapt(BundleWiring.class);
            resourceBundleLoaders.add(new ClassResourceBundleLoader("content.Language", bundleWiring.getClassLoader()));
        }
        resourceBundleLoaders.add(LanguageUtil.getPortalResourceBundleLoader());
        AggregateResourceBundleLoader aggregateResourceBundleLoader = new AggregateResourceBundleLoader(resourceBundleLoaders.toArray(new ResourceBundleLoader[0]));
        return aggregateResourceBundleLoader.loadResourceBundle(locale);
    }

    private void _setBaseContext() {
        this.context = this._soyContextImpl;
    }
}

