/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.template.soy.internal.SoyProviderCapabilityBundleRegister;
import com.liferay.portal.template.soy.internal.SoyTofuCacheHandler;
import com.liferay.portal.template.soy.internal.util.SoyTemplateResourcesCollector;
import com.liferay.portal.template.soy.internal.util.SoyTemplateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class SoyCapabilityBundleTrackerCustomizer
implements BundleTrackerCustomizer<List<BundleCapability>> {
    private static final Log _log = LogFactoryUtil.getLog(SoyCapabilityBundleTrackerCustomizer.class);
    private static final List<TemplateResource> _templateResources = new CopyOnWriteArrayList<TemplateResource>();
    private final SoyProviderCapabilityBundleRegister _soyProviderCapabilityBundleRegister;
    private final SoyTofuCacheHandler _soyTofuCacheHandler;

    public SoyCapabilityBundleTrackerCustomizer(SoyTofuCacheHandler soyTofuCacheHandler, SoyProviderCapabilityBundleRegister soyProviderCapabilityBundleRegister) {
        this._soyTofuCacheHandler = soyTofuCacheHandler;
        this._soyProviderCapabilityBundleRegister = soyProviderCapabilityBundleRegister;
    }

    public List<BundleCapability> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return null;
        }
        List bundleCapabilities = bundleWiring.getCapabilities("soy");
        if (ListUtil.isEmpty((List)bundleCapabilities)) {
            return bundleCapabilities;
        }
        for (BundleWire bundleWire : bundleWiring.getRequiredWires("soy")) {
            BundleRevision bundleRevision = bundleWire.getProvider();
            Bundle requiredBundle = bundleRevision.getBundle();
            this._soyProviderCapabilityBundleRegister.register(requiredBundle);
            this._addTemplateResourcesToList(requiredBundle);
        }
        this._soyProviderCapabilityBundleRegister.register(bundle);
        this._addTemplateResourcesToList(bundle);
        return bundleCapabilities;
    }

    public List<TemplateResource> getAllTemplateResources() {
        return _templateResources;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<BundleCapability> bundleCapabilities) {
        this.removedBundle(bundle, bundleEvent, bundleCapabilities);
        Object newBundleCapabilities = this.addingBundle(bundle, bundleEvent);
        bundleCapabilities.clear();
        bundleCapabilities.addAll((Collection<BundleCapability>)newBundleCapabilities);
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<BundleCapability> bundleCapabilities) {
        List<TemplateResource> removedTemplateResources = this._removeBundleTemplateResourcesFromList(bundle);
        this._soyTofuCacheHandler.removeIfAny(removedTemplateResources);
        this._soyProviderCapabilityBundleRegister.unregister(bundle);
    }

    private void _addTemplateResourcesToList(Bundle bundle) {
        block2: {
            SoyTemplateResourcesCollector soyTemplateResourcesCollector = new SoyTemplateResourcesCollector(bundle, "/");
            try {
                List<TemplateResource> templateResources = soyTemplateResourcesCollector.getTemplateResources();
                Stream templateResourcesStream = templateResources.stream();
                templateResourcesStream.forEach(templateResource -> {
                    if (templateResource != null && !_templateResources.contains(templateResource)) {
                        _templateResources.add((TemplateResource)templateResource);
                    }
                });
            }
            catch (TemplateException te) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)("Unable to add template resources for bundle " + bundle.getBundleId()), (Throwable)te);
            }
        }
    }

    private List<TemplateResource> _removeBundleTemplateResourcesFromList(Bundle bundle) {
        ArrayList<TemplateResource> removedTemplateResources = new ArrayList<TemplateResource>();
        for (TemplateResource templateResource : _templateResources) {
            long bundleId = SoyTemplateUtil.getBundleId(templateResource.getTemplateId());
            if (bundle.getBundleId() != bundleId) continue;
            removedTemplateResources.add(templateResource);
        }
        _templateResources.removeAll(removedTemplateResources);
        return removedTemplateResources;
    }
}

