
package com.google.template.soy.error;

import com.google.common.base.Optional;
import com.google.template.soy.base.SourceLocation;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_SoyError extends SoyError {

  private final SourceLocation location;
  private final SoyErrorKind errorKind;
  private final String message;
  private final Optional<String> snippet;
  private final boolean isWarning;

  AutoValue_SoyError(
      SourceLocation location,
      SoyErrorKind errorKind,
      String message,
      Optional<String> snippet,
      boolean isWarning) {
    if (location == null) {
      throw new NullPointerException("Null location");
    }
    this.location = location;
    if (errorKind == null) {
      throw new NullPointerException("Null errorKind");
    }
    this.errorKind = errorKind;
    if (message == null) {
      throw new NullPointerException("Null message");
    }
    this.message = message;
    if (snippet == null) {
      throw new NullPointerException("Null snippet");
    }
    this.snippet = snippet;
    this.isWarning = isWarning;
  }

  @Override
  public SourceLocation location() {
    return location;
  }

  @Override
  public SoyErrorKind errorKind() {
    return errorKind;
  }

  @Override
  public String message() {
    return message;
  }

  @Override
  Optional<String> snippet() {
    return snippet;
  }

  @Override
  public boolean isWarning() {
    return isWarning;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SoyError) {
      SoyError that = (SoyError) o;
      return (this.location.equals(that.location()))
           && (this.errorKind.equals(that.errorKind()))
           && (this.message.equals(that.message()))
           && (this.snippet.equals(that.snippet()))
           && (this.isWarning == that.isWarning());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.location.hashCode();
    h *= 1000003;
    h ^= this.errorKind.hashCode();
    h *= 1000003;
    h ^= this.message.hashCode();
    h *= 1000003;
    h ^= this.snippet.hashCode();
    h *= 1000003;
    h ^= this.isWarning ? 1231 : 1237;
    return h;
  }

}
