/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.SetUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class SoyTemplateResourcesCollectorUtil {
    private static final String _SOY_FILE_EXTENSION = "*.soy";
    private static final Log _log = LogFactoryUtil.getLog(SoyTemplateResourcesCollectorUtil.class);

    public static void collectBundleTemplateResources(Bundle bundle, String templatePath, List<TemplateResource> templateResources, Map<Bundle, Collection<URL>> collectionURLsMap) throws TemplateException {
        Enumeration<URL> enumeration = SoyTemplateResourcesCollectorUtil._findEntries(bundle, templatePath, collectionURLsMap);
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            String templateId = SoyTemplateResourcesCollectorUtil._getTemplateId(bundle.getBundleId(), url);
            try {
                TemplateResource templateResource = SoyTemplateResourcesCollectorUtil._getTemplateResource(templateId, url);
                templateResources.add(templateResource);
            }
            catch (IllegalStateException illegalStateException) {
                _log.error((Object)String.format("{providerBundle=%s, templateId=%s}", bundle.getSymbolicName(), templateId));
                throw illegalStateException;
            }
        }
    }

    public static List<TemplateResource> getTemplateResources(Bundle bundle, String templatePath) throws TemplateException {
        ArrayList<TemplateResource> templateResources = new ArrayList<TemplateResource>();
        SoyTemplateResourcesCollectorUtil.collectBundleTemplateResources(bundle, templatePath, templateResources, null);
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        for (BundleWire bundleWire : bundleWiring.getRequiredWires("soy")) {
            BundleRevision bundleRevision = bundleWire.getProvider();
            Bundle providerBundle = bundleRevision.getBundle();
            SoyTemplateResourcesCollectorUtil.collectBundleTemplateResources(providerBundle, "/", templateResources, null);
        }
        return templateResources;
    }

    private static Enumeration<URL> _findEntries(Bundle bundle, String templatePath, Map<Bundle, Collection<URL>> collectionURLsMap) {
        Collection<URL> collection;
        if (collectionURLsMap != null && (collection = collectionURLsMap.get(bundle)) != null) {
            return Collections.enumeration(collection);
        }
        Enumeration enumeration = bundle.findEntries(templatePath, _SOY_FILE_EXTENSION, true);
        if (enumeration == null) {
            if (collectionURLsMap != null) {
                collectionURLsMap.put(bundle, Collections.emptySet());
            }
            return null;
        }
        if (collectionURLsMap != null) {
            Set collection2 = SetUtil.fromEnumeration((Enumeration)enumeration);
            collectionURLsMap.put(bundle, collection2);
            return Collections.enumeration(collection2);
        }
        return enumeration;
    }

    private static String _getTemplateId(long bundleId, URL url) {
        return String.valueOf(bundleId).concat("_BUNDLE_CONTEXT_").concat(url.getPath());
    }

    private static TemplateResource _getTemplateResource(String templateId, URL url) throws TemplateException {
        Object templateResource = TemplateResourceLoaderUtil.hasTemplateResourceLoader((String)"soy") ? TemplateResourceLoaderUtil.getTemplateResource((String)"soy", (String)templateId) : new URLTemplateResource(templateId, url);
        return templateResource;
    }
}

