/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.google.template.soy.SoyFileSet;
import com.google.template.soy.tofu.SoyTofu;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.soy.internal.SoyTofuCacheBag;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

public class SoyTofuCacheHandler {
    private final PortalCache<String, SoyTofuCacheBag> _portalCache;

    public SoyTofuCacheHandler(PortalCache<String, SoyTofuCacheBag> portalCache) {
        this._portalCache = portalCache;
    }

    public SoyTofuCacheBag add(String templateId, SoyFileSet soyFileSet, SoyTofu soyTofu) {
        SoyTofuCacheBag soyTofuCacheBag = new SoyTofuCacheBag(soyFileSet, soyTofu);
        this._portalCache.put((Serializable)((Object)templateId), (Object)soyTofuCacheBag);
        return soyTofuCacheBag;
    }

    public SoyTofuCacheBag get(String templateId) {
        return (SoyTofuCacheBag)this._portalCache.get((Serializable)((Object)templateId));
    }

    public void removeIfAny(List<TemplateResource> templateResources) {
        for (TemplateResource templateResource : templateResources) {
            String templateId = templateResource.getTemplateId();
            for (String key : this._portalCache.getKeys()) {
                if (!key.equals(templateId) && !key.startsWith(templateId + ",") && !key.endsWith("," + templateId) && !key.contains("," + templateId + ",")) continue;
                this._portalCache.remove((Serializable)((Object)key));
            }
        }
    }

    public void removeIfAny(Locale locale) {
        for (String key : this._portalCache.getKeys()) {
            SoyTofuCacheBag soyTofuCacheBag = (SoyTofuCacheBag)this._portalCache.get((Serializable)((Object)key));
            if (soyTofuCacheBag == null) continue;
            soyTofuCacheBag.removeMessageBundle(locale);
        }
    }
}

