/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.template.soy.SoyTemplateResource;
import com.liferay.portal.template.soy.SoyTemplateResourceFactory;
import com.liferay.portal.template.soy.internal.SoyProviderCapabilityBundleRegister;
import com.liferay.portal.template.soy.internal.SoyTofuCacheHandler;
import com.liferay.portal.template.soy.internal.util.SoyTemplateResourcesCollectorUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class SoyTemplateResourceBundleTrackerCustomizer
implements BundleTrackerCustomizer<List<TemplateResource>> {
    private static final Log _log = LogFactoryUtil.getLog(SoyTemplateResourceBundleTrackerCustomizer.class);
    private static final Set<TemplateResource> _templateResources = new CopyOnWriteArraySet<TemplateResource>();
    private final Map<Bundle, Collection<URL>> _collectionURLsMap = new ConcurrentHashMap<Bundle, Collection<URL>>();
    private final SoyProviderCapabilityBundleRegister _soyProviderCapabilityBundleRegister;
    private volatile SoyTemplateResource _soyTemplateResource;
    private final SoyTemplateResourceFactory _soyTemplateResourceFactory;
    private final SoyTofuCacheHandler _soyTofuCacheHandler;

    public SoyTemplateResourceBundleTrackerCustomizer(SoyTofuCacheHandler soyTofuCacheHandler, SoyProviderCapabilityBundleRegister soyProviderCapabilityBundleRegister, SoyTemplateResourceFactory soyTemplateResourceFactory) {
        this._soyTofuCacheHandler = soyTofuCacheHandler;
        this._soyProviderCapabilityBundleRegister = soyProviderCapabilityBundleRegister;
        this._soyTemplateResourceFactory = soyTemplateResourceFactory;
    }

    public List<TemplateResource> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        ArrayList<TemplateResource> templateResources;
        BundleWiring bundleWiring;
        block6: {
            bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List bundleCapabilities = bundleWiring.getCapabilities("soy");
            if (ListUtil.isEmpty((List)bundleCapabilities)) {
                return Collections.emptyList();
            }
            templateResources = new ArrayList<TemplateResource>();
            try {
                SoyTemplateResourcesCollectorUtil.collectBundleTemplateResources(bundle, "/", templateResources, this._collectionURLsMap);
                this._soyProviderCapabilityBundleRegister.register(bundle);
            }
            catch (TemplateException templateException) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)("Unable to add template resources for bundle " + bundle.getBundleId()), (Throwable)templateException);
            }
        }
        for (BundleWire bundleWire : bundleWiring.getRequiredWires("soy")) {
            BundleRevision bundleRevision = bundleWire.getProvider();
            Bundle providerBundle = bundleRevision.getBundle();
            try {
                SoyTemplateResourcesCollectorUtil.collectBundleTemplateResources(providerBundle, "/", templateResources, this._collectionURLsMap);
                this._soyProviderCapabilityBundleRegister.register(providerBundle);
            }
            catch (TemplateException templateException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to add template resources for bundle " + bundle.getBundleId()), (Throwable)templateException);
            }
        }
        _templateResources.addAll(templateResources);
        this._soyTemplateResource = null;
        return templateResources;
    }

    @Deprecated
    public List<TemplateResource> getAllTemplateResources() {
        return new ArrayList<TemplateResource>(_templateResources);
    }

    public SoyTemplateResource getSoyTemplateResource() {
        SoyTemplateResource soyTemplateResource = this._soyTemplateResource;
        if (soyTemplateResource == null) {
            soyTemplateResource = this._soyTemplateResourceFactory.createSoyTemplateResource(new ArrayList<TemplateResource>(_templateResources));
        }
        this._soyTemplateResource = soyTemplateResource;
        return soyTemplateResource;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<TemplateResource> templateResources) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<TemplateResource> templateResources) {
        if (templateResources == Collections.emptyList()) {
            return;
        }
        _templateResources.removeAll(templateResources);
        this._soyTemplateResource = null;
        this._soyTofuCacheHandler.removeIfAny(templateResources);
        this._soyProviderCapabilityBundleRegister.unregister(bundle);
        this._collectionURLsMap.remove(bundle);
    }
}

