/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.ibm.icu.util.ULocale;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class SoyMsgBundleBridge
extends SoyMsgBundle {
    private static final String _PLACEHOLDER = "__SOY_MSG_PLACEHOLDER__";
    private final String _languageId;
    private final boolean _rtl;
    private final Map<Long, SoyMsg> _soyMsgMap = new HashMap<Long, SoyMsg>();
    private final ULocale _uLocale;

    public SoyMsgBundleBridge(SoyMsgBundle soyMsgBundle, Locale locale, ResourceBundle resourceBundle) {
        this._languageId = LanguageUtil.getLanguageId((Locale)locale);
        this._rtl = soyMsgBundle.isRtl();
        for (SoyMsg soyMsg : soyMsgBundle) {
            SoyMsg.Builder builder = SoyMsg.builder();
            builder.setLocaleString(this._languageId);
            builder.setIsPlrselMsg(false);
            builder.setParts(SoyMsgBundleBridge._getLocalizedMessageParts(resourceBundle, soyMsg));
            this._soyMsgMap.put(soyMsg.getId(), builder.build());
        }
        this._uLocale = soyMsgBundle.getLocale();
    }

    public ULocale getLocale() {
        return this._uLocale;
    }

    public String getLocaleString() {
        return this._languageId;
    }

    public SoyMsg getMsg(long messageId) {
        return this._soyMsgMap.get(messageId);
    }

    public int getNumMsgs() {
        return this._soyMsgMap.size();
    }

    public boolean isRtl() {
        return this._rtl;
    }

    public Iterator<SoyMsg> iterator() {
        Collection<SoyMsg> values = this._soyMsgMap.values();
        return values.iterator();
    }

    private static List<SoyMsgPart> _getLocalizedMessageParts(ResourceBundle resourceBundle, SoyMsg soyMsg) {
        String[] localizedTextParts;
        ImmutableList soyMsgParts = soyMsg.getParts();
        StringBundler sb = new StringBundler(soyMsgParts.size());
        LinkedList<SoyMsgPart> placeholderParts = new LinkedList<SoyMsgPart>();
        ArrayList<String> placeholderStrings = new ArrayList<String>();
        for (SoyMsgPart soyMsgPart : soyMsgParts) {
            if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                placeholderParts.add(soyMsgPart);
                placeholderStrings.add(_PLACEHOLDER);
                sb.append('x');
                continue;
            }
            SoyMsgRawTextPart soyMsgRawTextPart = (SoyMsgRawTextPart)soyMsgPart;
            sb.append(soyMsgRawTextPart.getRawText());
        }
        String localizedText = LanguageUtil.format((ResourceBundle)resourceBundle, (String)sb.toString(), (Object[])placeholderStrings.toArray());
        ArrayList<SoyMsgPart> localizedSoyMsgParts = new ArrayList<SoyMsgPart>();
        for (String localizedTextPart : localizedTextParts = StringUtil.split((String)localizedText, (String)_PLACEHOLDER)) {
            localizedSoyMsgParts.add((SoyMsgPart)SoyMsgRawTextPart.of((String)localizedTextPart));
            if (placeholderParts.isEmpty()) continue;
            localizedSoyMsgParts.add((SoyMsgPart)placeholderParts.poll());
        }
        return localizedSoyMsgParts;
    }
}

