/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.template.soy.data.SoyDataFactory;
import com.liferay.portal.template.soy.internal.SoyTemplateRecord;
import com.liferay.portal.template.soy.internal.data.SoyDataFactoryProvider;
import com.liferay.portal.template.soy.util.SoyContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SoyContextImpl
implements SoyContext {
    private final Map<String, Object> _map;
    private final Set<String> _restrictedVariables;

    public SoyContextImpl() {
        this(Collections.emptyMap(), Collections.emptySet());
    }

    public SoyContextImpl(Map<String, Object> context) {
        this(context, Collections.emptySet());
    }

    public SoyContextImpl(Map<String, Object> context, Set<String> restrictedVariables) {
        this._map = new HashMap<String, Object>(context);
        this._restrictedVariables = restrictedVariables;
    }

    public void clear() {
        this._map.clear();
    }

    public SoyContext clearInjectedData() {
        this._map.remove("_INJECTED_DATA_");
        return this;
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    public SoyTemplateRecord createInjectedSoyTemplateRecord() {
        Map<String, Object> injectedData = (Map<String, Object>)this._map.get("_INJECTED_DATA_");
        if (injectedData == null) {
            injectedData = Collections.emptyMap();
        }
        return new SoyTemplateRecord(this._filterRestrictedVariables(injectedData));
    }

    public SoyTemplateRecord createSoyTemplateRecord() {
        return new SoyTemplateRecord(this._filterRestrictedVariables(this._map));
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this._map.entrySet();
    }

    public Object get(Object key) {
        return this._map.get(key);
    }

    public Object getInjectedData(String key) {
        Map injectedData = (Map)this._map.get("_INJECTED_DATA_");
        if (injectedData == null) {
            return null;
        }
        return injectedData.get(key);
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Set<String> keySet() {
        return this._map.keySet();
    }

    public SoyContext put(String key, Object value) {
        if (key.equals("_INJECTED_DATA_") && !(value instanceof Map)) {
            throw new IllegalArgumentException("Injected data must be a Map");
        }
        this._map.put(key, value);
        return this;
    }

    public SoyContext put(String key, UnsafeSupplier<?, Exception> unsafeSupplier) {
        Object value = null;
        if (unsafeSupplier != null) {
            try {
                value = unsafeSupplier.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.put(key, value);
        return this;
    }

    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public SoyContext putHTML(String key, String value) {
        SoyDataFactory soyDataFactory = SoyDataFactoryProvider.getSoyDataFactory();
        this._map.put(key, soyDataFactory.createSoyRawData(value));
        return this;
    }

    public SoyContext putInjectedData(String key, Object value) {
        HashMap<String, Object> injectedData = (HashMap<String, Object>)this._map.get("_INJECTED_DATA_");
        if (injectedData == null) {
            injectedData = new HashMap<String, Object>();
            this._map.put("_INJECTED_DATA_", injectedData);
        }
        injectedData.put(key, value);
        return this;
    }

    public Object remove(Object key) {
        return this._map.remove(key);
    }

    public SoyContext removeInjectedData(String key) {
        Map injectedData = (Map)this._map.get("_INJECTED_DATA_");
        if (injectedData != null) {
            injectedData.remove(key);
        }
        return this;
    }

    public int size() {
        return this._map.size();
    }

    public Collection<Object> values() {
        return this._map.values();
    }

    private Map<String, Object> _filterRestrictedVariables(Map<String, Object> map) {
        HashMap<String, Object> filteredMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            Object value = entry.getValue();
            if (value == null || this._restrictedVariables.contains(key = entry.getKey())) continue;
            filteredMap.put(key, value);
        }
        return filteredMap;
    }
}

