/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.google.common.io.CharStreams;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.tofu.SoyTofu;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.AbstractMultiResourceTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.soy.internal.SoyMsgBundleBridge;
import com.liferay.portal.template.soy.internal.SoyProviderCapabilityBundleRegister;
import com.liferay.portal.template.soy.internal.SoyTemplateContextHelper;
import com.liferay.portal.template.soy.internal.SoyTemplateRecord;
import com.liferay.portal.template.soy.internal.SoyTofuCacheBag;
import com.liferay.portal.template.soy.internal.SoyTofuCacheHandler;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class SoyTemplate
extends AbstractMultiResourceTemplate {
    private static final Log _log = LogFactoryUtil.getLog(SoyTemplate.class);
    private SoyTemplateRecord _injectedSoyTemplateRecord;
    private final boolean _privileged;
    private SoyTemplateRecord _soyTemplateRecord;
    private final SoyTofuCacheHandler _soyTofuCacheHandler;
    private final SoyTemplateContextHelper _templateContextHelper;

    public SoyTemplate(List<TemplateResource> templateResources, TemplateResource errorTemplateResource, Map<String, Object> context, SoyTemplateContextHelper templateContextHelper, boolean privileged, SoyTofuCacheHandler soyTofuCacheHandler) {
        super(templateResources, errorTemplateResource, context, (TemplateContextHelper)templateContextHelper, "soy", 0L);
        this._templateContextHelper = templateContextHelper;
        this._privileged = privileged;
        this._injectedSoyTemplateRecord = new SoyTemplateRecord();
        this._soyTemplateRecord = new SoyTemplateRecord();
        this._soyTofuCacheHandler = soyTofuCacheHandler;
    }

    public void clear() {
        this._injectedSoyTemplateRecord = new SoyTemplateRecord();
        this._soyTemplateRecord = new SoyTemplateRecord();
        super.clear();
    }

    public void prepare(HttpServletRequest request) {
        HashMap<String, Object> injectedDataObjects = new HashMap<String, Object>();
        this._templateContextHelper.prepare(injectedDataObjects, request);
        for (Map.Entry entry : injectedDataObjects.entrySet()) {
            this.putInjectedData((String)entry.getKey(), entry.getValue());
        }
    }

    public Object put(String key, Object value) {
        TemplateContextHelper templateContextHelper = this.getTemplateContextHelper();
        Set restrictedVariables = templateContextHelper.getRestrictedVariables();
        Object currentValue = this.get(key);
        if (!restrictedVariables.contains(key) && !Objects.equals(value, currentValue)) {
            this._soyTemplateRecord.add(key, value);
        }
        return super.put(key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        for (String string : map.keySet()) {
            this.put(string, map.get(string));
        }
    }

    public void putInjectedData(String key, Object value) {
        this._injectedSoyTemplateRecord.add(key, value);
    }

    public Object remove(Object key) {
        if ("_INJECTED_DATA_".equals(key)) {
            this._injectedSoyTemplateRecord = new SoyTemplateRecord();
            return super.remove(key);
        }
        this._soyTemplateRecord.remove((String)key);
        return super.remove(key);
    }

    protected SoyMsgBundleBridge createSoyMsgBundleBridge(SoyFileSet soyFileSet, Locale locale) {
        SoyMsgBundle soyMsgBundle = soyFileSet.extractMsgs();
        ResourceBundle languageResourceBundle = this._getLanguageResourceBundle(locale);
        SoyMsgBundleBridge soyMsgBundleBridge = new SoyMsgBundleBridge((Iterable<SoyMsg>)soyMsgBundle, locale, languageResourceBundle);
        return soyMsgBundleBridge;
    }

    protected SoyTemplateRecord getInjectedSoyTemplateRecord() {
        if (this.containsKey("_INJECTED_DATA_")) {
            Map injectedData = (Map)this.get("_INJECTED_DATA_");
            for (Map.Entry entry : injectedData.entrySet()) {
                this.putInjectedData((String)entry.getKey(), entry.getValue());
            }
        }
        return this._injectedSoyTemplateRecord;
    }

    protected SoyFileSet getSoyFileSet(List<TemplateResource> templateResources) throws Exception {
        SoyFileSet soyFileSet = null;
        if (this._privileged) {
            soyFileSet = AccessController.doPrivileged(new TemplatePrivilegedExceptionAction(templateResources));
        } else {
            SoyFileSet.Builder builder = SoyFileSet.builder();
            HashSet<String> templateIds = new HashSet<String>();
            for (TemplateResource templateResource : templateResources) {
                if (templateIds.contains(templateResource.getTemplateId())) continue;
                templateIds.add(templateResource.getTemplateId());
                String templateContent = this.getTemplateContent(templateResource);
                builder.add((CharSequence)templateContent, templateResource.getTemplateId());
            }
            soyFileSet = builder.build();
        }
        return soyFileSet;
    }

    protected Optional<SoyMsgBundle> getSoyMsgBundle(SoyFileSet soyFileSet, SoyTofuCacheBag soyTofuCacheBag) {
        Locale locale = (Locale)this.get("locale");
        if (locale != null) {
            SoyMsgBundle soyMsgBundle = soyTofuCacheBag.getMessageBundle(locale);
            if (soyMsgBundle == null) {
                soyMsgBundle = this.createSoyMsgBundleBridge(soyFileSet, locale);
                soyTofuCacheBag.putMessageBundle(locale, soyMsgBundle);
            }
            return Optional.of(soyMsgBundle);
        }
        return Optional.empty();
    }

    protected SoyTemplateRecord getSoyTemplateRecord() {
        return this._soyTemplateRecord;
    }

    protected SoyTofuCacheBag getSoyTofuCacheBag(List<TemplateResource> templateResources) throws Exception {
        SoyTofuCacheBag soyTofuCacheBag = this._soyTofuCacheHandler.get(templateResources);
        if (soyTofuCacheBag == null) {
            SoyFileSet soyFileSet = this.getSoyFileSet(templateResources);
            SoyTofu soyTofu = soyFileSet.compileToTofu();
            soyTofuCacheBag = this._soyTofuCacheHandler.add(templateResources, soyFileSet, soyTofu);
        }
        return soyTofuCacheBag;
    }

    protected String getTemplateContent(TemplateResource templateResource) throws Exception {
        Reader reader = templateResource.getReader();
        return CharStreams.toString((Readable)reader);
    }

    protected TemplateContextHelper getTemplateContextHelper() {
        return this._templateContextHelper;
    }

    protected void handleException(Exception exception, Writer writer) throws TemplateException {
        this.put("exception", (Object)exception.getMessage());
        StringBundler sb = new StringBundler();
        for (TemplateResource templateResource : this.templateResources) {
            if (!(templateResource instanceof StringTemplateResource)) continue;
            StringTemplateResource stringTemplateResource = (StringTemplateResource)templateResource;
            sb.append(stringTemplateResource.getContent());
        }
        this.put("script", (Object)sb.toString());
        try {
            this.processTemplates(Arrays.asList(this.errorTemplateResource), writer);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to process Soy template " + this.errorTemplateResource.getTemplateId(), (Throwable)e);
        }
    }

    protected void processTemplates(List<TemplateResource> templateResources, Writer writer) throws Exception {
        try {
            boolean renderStrict;
            String namespace = GetterUtil.getString((Object)this.get("namespace"));
            if (Validator.isNull((String)namespace)) {
                throw new TemplateException("Namespace is not specified");
            }
            SoyTofuCacheBag soyTofuCacheBag = this.getSoyTofuCacheBag(templateResources);
            SoyTofu soyTofu = soyTofuCacheBag.getSoyTofu();
            SoyTofu.Renderer renderer = soyTofu.newRenderer(namespace);
            renderer.setData((SoyRecord)this.getSoyTemplateRecord());
            renderer.setIjData((SoyRecord)this.getInjectedSoyTemplateRecord());
            SoyFileSet soyFileSet = soyTofuCacheBag.getSoyFileSet();
            Optional<SoyMsgBundle> soyMsgBundle = this.getSoyMsgBundle(soyFileSet, soyTofuCacheBag);
            if (soyMsgBundle.isPresent()) {
                renderer.setMsgBundle(soyMsgBundle.get());
            }
            if (renderStrict = GetterUtil.getBoolean((Object)this.get("render_strict"), (boolean)true)) {
                SanitizedContent sanitizedContent = renderer.renderStrict();
                writer.write(sanitizedContent.stringValue());
            } else {
                writer.write(renderer.render());
            }
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    private ResourceBundle _getLanguageResourceBundle(Locale locale) {
        ArrayList<Object> resourceBundleLoaders = new ArrayList<Object>();
        for (TemplateResource templateResource : this.templateResources) {
            try {
                Bundle templateResourceBundle = SoyProviderCapabilityBundleRegister.getTemplateBundle(templateResource.getTemplateId());
                BundleWiring bundleWiring = (BundleWiring)templateResourceBundle.adapt(BundleWiring.class);
                resourceBundleLoaders.add(new ClassResourceBundleLoader("content.Language", bundleWiring.getClassLoader()));
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                String templateId = templateResource.getTemplateId();
                _log.debug((Object)("Unable to get language resource bundle for template " + StringUtil.quote((String)templateId)), (Throwable)e);
            }
        }
        resourceBundleLoaders.add(LanguageUtil.getPortalResourceBundleLoader());
        AggregateResourceBundleLoader aggregateResourceBundleLoader = new AggregateResourceBundleLoader(resourceBundleLoaders.toArray(new ResourceBundleLoader[resourceBundleLoaders.size()]));
        return aggregateResourceBundleLoader.loadResourceBundle(locale);
    }

    private class TemplatePrivilegedExceptionAction
    implements PrivilegedExceptionAction<SoyFileSet> {
        private final List<TemplateResource> _templateResources;

        public TemplatePrivilegedExceptionAction(List<TemplateResource> templateResources) {
            this._templateResources = templateResources;
        }

        @Override
        public SoyFileSet run() throws Exception {
            SoyFileSet.Builder builder = SoyFileSet.builder();
            for (TemplateResource templateResource : this._templateResources) {
                String templateContent = SoyTemplate.this.getTemplateContent(templateResource);
                builder.add((CharSequence)templateContent, templateResource.getTemplateId());
            }
            return builder.build();
        }
    }
}

