/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class SoyMsgBundleBridge
extends SoyMsgBundle {
    private static final String _PLACEHOLDER = "__SOY_MSG_PLACEHOLDER__";
    private final Locale _locale;
    private final Iterable<SoyMsg> _messages;
    private final ResourceBundle _resourceBundle;

    public SoyMsgBundleBridge(Iterable<SoyMsg> messages, Locale locale, ResourceBundle resourceBundle) {
        this._messages = messages;
        this._locale = locale;
        this._resourceBundle = resourceBundle;
    }

    public String getLocaleString() {
        return LanguageUtil.getLanguageId((Locale)this._locale);
    }

    public SoyMsg getMsg(long messageId) {
        SoyMsg soyMsg = this._getMsg(messageId);
        SoyMsg.Builder builder = SoyMsg.builder();
        builder.setLocaleString(this.getLocaleString());
        builder.setIsPlrselMsg(false);
        builder.setParts(this._getLocalizedMessageParts(soyMsg));
        return builder.build();
    }

    public int getNumMsgs() {
        int count = 0;
        Iterator<SoyMsg> iterator = this._messages.iterator();
        while (iterator.hasNext()) {
            ++count;
        }
        return count;
    }

    public Iterator<SoyMsg> iterator() {
        return this._messages.iterator();
    }

    private List<SoyMsgPart> _getLocalizedMessageParts(SoyMsg soyMsg) {
        String[] localizedTextParts;
        ImmutableList soyMsgParts = soyMsg.getParts();
        StringBundler sb = new StringBundler(soyMsgParts.size());
        LinkedList<SoyMsgPart> placeholderParts = new LinkedList<SoyMsgPart>();
        ArrayList<String> placeholderStrings = new ArrayList<String>();
        for (SoyMsgPart soyMsgPart : soyMsgParts) {
            if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                placeholderParts.add(soyMsgPart);
                placeholderStrings.add(_PLACEHOLDER);
                sb.append('x');
                continue;
            }
            SoyMsgRawTextPart soyMsgRawTextPart = (SoyMsgRawTextPart)soyMsgPart;
            sb.append(soyMsgRawTextPart.getRawText());
        }
        String localizedText = LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)sb.toString(), (Object[])placeholderStrings.toArray());
        ArrayList<SoyMsgPart> localizedSoyMsgParts = new ArrayList<SoyMsgPart>();
        for (String localizedTextPart : localizedTextParts = StringUtil.split((String)localizedText, (String)_PLACEHOLDER)) {
            localizedSoyMsgParts.add((SoyMsgPart)SoyMsgRawTextPart.of((String)localizedTextPart));
            if (placeholderParts.isEmpty()) continue;
            localizedSoyMsgParts.add((SoyMsgPart)placeholderParts.poll());
        }
        return localizedSoyMsgParts;
    }

    private SoyMsg _getMsg(long messageId) {
        for (SoyMsg soyMsg : this._messages) {
            if (messageId != soyMsg.getId()) continue;
            return soyMsg;
        }
        return null;
    }
}

