/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.soy.internal;

import com.liferay.portal.template.soy.internal.util.SoyHTMLSanitizerUtil;
import com.liferay.portal.template.soy.utils.SoyContext;
import com.liferay.portal.template.soy.utils.SoyRawData;
import java.util.HashMap;
import java.util.Map;

public class SoyContextImpl
extends HashMap<String, Object>
implements SoyContext {
    private final Map<String, Object> _injectedData;

    public SoyContextImpl() {
        this._injectedData = new HashMap<String, Object>();
        this.put("_INJECTED_DATA_", this._injectedData);
    }

    public SoyContextImpl(Map<String, Object> context) {
        super(context);
        HashMap injectedData = (HashMap)this.get("_INJECTED_DATA_");
        if (injectedData == null) {
            injectedData = new HashMap();
            this.put("_INJECTED_DATA_", injectedData);
        }
        this._injectedData = injectedData;
    }

    public void clearInjectedData() {
        this._injectedData.clear();
    }

    public void putHTML(String key, final String value) {
        SoyRawData soyRawData = new SoyRawData(){

            public Object getValue() {
                return SoyHTMLSanitizerUtil.sanitize(value);
            }
        };
        this.put(key, soyRawData);
    }

    public void putInjectedData(String key, Object value) {
        this._injectedData.put(key, value);
    }

    public void removeInjectedData(String key) {
        this._injectedData.remove(key);
    }
}

