Liferay.Loader.define('portal-template-react-renderer-impl$lodash-es@4.17.15/isArrayLike', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import isFunction from './isFunction.js';
  import isLength from './isLength.js';

  /**
   * Checks if `value` is array-like. A value is considered array-like if it's
   * not a function and has a `value.length` that's an integer greater than or
   * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
   * @example
   *
   * _.isArrayLike([1, 2, 3]);
   * // => true
   *
   * _.isArrayLike(document.body.children);
   * // => true
   *
   * _.isArrayLike('abc');
   * // => true
   *
   * _.isArrayLike(_.noop);
   * // => false
   */
  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }

  export default isArrayLike;
});
//# sourceMappingURL=isArrayLike.js.map