Liferay.Loader.define("portal-template-react-renderer-impl$dnd-core@11.1.3/lib/utils/equality", ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    export const strictEquality = (a, b) => a === b;
    /**
     * Determine if two cartesian coordinate offsets are equal
     * @param offsetA
     * @param offsetB
     */
    export function areCoordsEqual(offsetA, offsetB) {
        if (!offsetA && !offsetB) {
            return true;
        } else if (!offsetA || !offsetB) {
            return false;
        } else {
            return offsetA.x === offsetB.x && offsetA.y === offsetB.y;
        }
    }
    /**
     * Determines if two arrays of items are equal
     * @param a The first array of items
     * @param b The second array of items
     */
    export function areArraysEqual(a, b, isEqual = strictEquality) {
        if (a.length !== b.length) {
            return false;
        }
        for (let i = 0; i < a.length; ++i) {
            if (!isEqual(a[i], b[i])) {
                return false;
            }
        }
        return true;
    }
});
//# sourceMappingURL=equality.js.map