/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @typechecks static-only
 */

'use strict';

/**
 * Combines multiple className strings into one.
 * http://jsperf.com/joinclasses-args-vs-array
 *
 * @param {...?string} className
 * @return {string}
 */

Liferay.Loader.define('portal-template-react-renderer-impl$fbjs@0.8.17/lib/joinClasses', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function joinClasses(className /*, ... */) {
    if (!className) {
      className = '';
    }
    var nextClass = void 0;
    var argLength = arguments.length;
    if (argLength > 1) {
      for (var ii = 1; ii < argLength; ii++) {
        nextClass = arguments[ii];
        if (nextClass) {
          className = (className ? className + ' ' : '') + nextClass;
        }
      }
    }
    return className;
  }

  module.exports = joinClasses;
});
//# sourceMappingURL=joinClasses.js.map