'use strict';

Liferay.Loader.define('portal-template-react-renderer-impl$deepmerge@2.2.1/dist/cjs', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	var isMergeableObject = function isMergeableObject(value) {
		return isNonNullObject(value) && !isSpecial(value);
	};

	function isNonNullObject(value) {
		return !!value && typeof value === 'object';
	}

	function isSpecial(value) {
		var stringValue = Object.prototype.toString.call(value);

		return stringValue === '[object RegExp]' || stringValue === '[object Date]' || isReactElement(value);
	}

	// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
	var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
	var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

	function isReactElement(value) {
		return value.$$typeof === REACT_ELEMENT_TYPE;
	}

	function emptyTarget(val) {
		return Array.isArray(val) ? [] : {};
	}

	function cloneUnlessOtherwiseSpecified(value, optionsArgument) {
		var cloneOptionWasSpecified = optionsArgument && typeof optionsArgument.clone === 'boolean';
		var clone = !cloneOptionWasSpecified || optionsArgument.clone === true;

		return clone && isMergeableObject(value) ? deepmerge(emptyTarget(value), value, optionsArgument) : value;
	}

	function defaultArrayMerge(target, source, optionsArgument) {
		var destination = target.slice();
		source.forEach(function (e, i) {
			if (typeof destination[i] === 'undefined') {
				destination[i] = cloneUnlessOtherwiseSpecified(e, optionsArgument);
			} else if (isMergeableObject(e)) {
				destination[i] = deepmerge(target[i], e, optionsArgument);
			} else if (target.indexOf(e) === -1) {
				destination.push(cloneUnlessOtherwiseSpecified(e, optionsArgument));
			}
		});
		return destination;
	}

	function mergeObject(target, source, optionsArgument) {
		var destination = {};
		if (isMergeableObject(target)) {
			Object.keys(target).forEach(function (key) {
				destination[key] = cloneUnlessOtherwiseSpecified(target[key], optionsArgument);
			});
		}
		Object.keys(source).forEach(function (key) {
			if (!isMergeableObject(source[key]) || !target[key]) {
				destination[key] = cloneUnlessOtherwiseSpecified(source[key], optionsArgument);
			} else {
				destination[key] = deepmerge(target[key], source[key], optionsArgument);
			}
		});
		return destination;
	}

	function deepmerge(target, source, optionsArgument) {
		var sourceIsArray = Array.isArray(source);
		var targetIsArray = Array.isArray(target);


		if (!(sourceIsArray === targetIsArray)) {
			return cloneUnlessOtherwiseSpecified(source, optionsArgument);
		} else if (sourceIsArray) {
			var arrayMerge = (optionsArgument || { arrayMerge: defaultArrayMerge }).arrayMerge || defaultArrayMerge;
			return arrayMerge(target, source, optionsArgument);
		} else {
			return mergeObject(target, source, optionsArgument);
		}
	}

	deepmerge.all = function deepmergeAll(array, optionsArgument) {
		if (!Array.isArray(array) || array.length < 2) {
			throw new Error('first argument should be an array with at least two elements');
		}

		// we are sure there are at least 2 values, so it is safe to have no initial value
		return array.reduce(function (prev, next) {
			return deepmerge(prev, next, optionsArgument);
		});
	};

	var deepmerge_1 = deepmerge;

	module.exports = deepmerge_1;
});
//# sourceMappingURL=cjs.js.map