Liferay.Loader.define('portal-template-react-renderer-impl$lodash-es@4.17.11/padStart', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import createPadding from './_createPadding.js';
  import stringSize from './_stringSize.js';
  import toInteger from './toInteger.js';
  import toString from './toString.js';

  /**
   * Pads `string` on the left side if it's shorter than `length`. Padding
   * characters are truncated if they exceed `length`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category String
   * @param {string} [string=''] The string to pad.
   * @param {number} [length=0] The padding length.
   * @param {string} [chars=' '] The string used as padding.
   * @returns {string} Returns the padded string.
   * @example
   *
   * _.padStart('abc', 6);
   * // => '   abc'
   *
   * _.padStart('abc', 6, '_-');
   * // => '_-_abc'
   *
   * _.padStart('abc', 3);
   * // => 'abc'
   */
  function padStart(string, length, chars) {
    string = toString(string);
    length = toInteger(length);

    var strLength = length ? stringSize(string) : 0;
    return length && strLength < length ? createPadding(length - strLength, chars) + string : string;
  }

  export default padStart;
});
//# sourceMappingURL=padStart.js.map