/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.freemarker.internal.LiferayFreeMarkerBeanModel;
import com.liferay.portal.template.freemarker.internal.LiferayTemplateModel;
import com.liferay.portal.util.PortalImpl;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.EnumerationModel;
import freemarker.ext.beans.MapModel;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.ext.beans.StringModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.util.ModelFactory;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Node;

public class LiferayObjectWrapper
extends DefaultObjectWrapper {
    private static final ModelFactory _ENUMERATION_MODEL_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new EnumerationModel((Enumeration)object, (BeansWrapper)objectWrapper);
        }
    };
    private static final ModelFactory _LIFERAY_FREEMARKER_BEAN_MODEL_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new LiferayFreeMarkerBeanModel(object, (BeansWrapper)objectWrapper);
        }
    };
    private static final ModelFactory _NODE_MODEL_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return NodeModel.wrap((Node)object);
        }
    };
    private static final ModelFactory _RESOURCE_BUNDLE_MODEL_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new ResourceBundleModel((ResourceBundle)object, (BeansWrapper)objectWrapper);
        }
    };
    private static final ModelFactory _STRING_MODEL_FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new StringModel(object, (BeansWrapper)objectWrapper);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(LiferayObjectWrapper.class);
    private static final Field _cacheClassNamesField;
    private static final Field _classIntrospectorField;
    private static final Map<Class<?>, ModelFactory> _modelFactories;
    private static final ClassRestrictionInformation _nullInstance;
    private final boolean _allowAllClasses;
    private final List<String> _allowedClassNames;
    private final Map<String, ClassRestrictionInformation> _classRestrictionInformations = new ConcurrentHashMap<String, ClassRestrictionInformation>();
    private final List<Class<?>> _restrictedClasses;
    private final Map<String, Set<String>> _restrictedMethodNames;
    private final List<String> _restrictedPackageNames;

    public LiferayObjectWrapper(String[] allowedClassNames, String[] restrictedClassNames, String[] restrictedMethodNames) {
        super(Configuration.getVersion());
        try {
            _cacheClassNamesField.set(_classIntrospectorField.get(this), new HashSet<Object>(){

                @Override
                public boolean add(Object object) {
                    return false;
                }

                @Override
                public void clear() {
                }

                @Override
                public boolean contains(Object object) {
                    return false;
                }

                @Override
                public boolean remove(Object object) {
                    return false;
                }
            });
        }
        catch (Exception e) {
            ReflectionUtil.throwException((Throwable)e);
        }
        if (allowedClassNames == null) {
            this._allowedClassNames = Collections.emptyList();
        } else {
            this._allowedClassNames = new ArrayList<String>(allowedClassNames.length);
            for (String allowedClassName : allowedClassNames) {
                if (Validator.isBlank((String)(allowedClassName = StringUtil.trim((String)allowedClassName)))) continue;
                this._allowedClassNames.add(allowedClassName);
            }
        }
        if (restrictedMethodNames == null) {
            this._restrictedMethodNames = Collections.emptyMap();
        } else {
            this._restrictedMethodNames = new HashMap<String, Set<String>>(restrictedMethodNames.length);
            for (String restrictedMethodName : restrictedMethodNames) {
                int index = restrictedMethodName.indexOf(35);
                if (index < 0) {
                    _log.error((Object)StringBundler.concat((String[])new String[]{"\"", restrictedMethodName, "\" does not match format ", "\"className#methodName\""}));
                    continue;
                }
                String className = StringUtil.trim((String)restrictedMethodName.substring(0, index));
                String methodName = StringUtil.trim((String)restrictedMethodName.substring(index + 1));
                Set methodNames = this._restrictedMethodNames.computeIfAbsent(className, key -> new HashSet());
                methodNames.add(StringUtil.toLowerCase((String)methodName));
            }
        }
        this._allowAllClasses = this._allowedClassNames.contains("*");
        if (restrictedClassNames == null) {
            this._restrictedClasses = Collections.emptyList();
            this._restrictedPackageNames = Collections.emptyList();
        } else {
            this._restrictedClasses = new ArrayList(restrictedClassNames.length);
            this._restrictedPackageNames = new ArrayList<String>();
            AggregateClassLoader aggregateClassLoader = new AggregateClassLoader(LiferayObjectWrapper.class.getClassLoader());
            aggregateClassLoader.addClassLoader(PortalImpl.class.getClassLoader());
            Thread thread = Thread.currentThread();
            if (thread.getContextClassLoader() != null) {
                aggregateClassLoader.addClassLoader(thread.getContextClassLoader());
            }
            for (String restrictedClassName : restrictedClassNames) {
                if (Validator.isBlank((String)(restrictedClassName = StringUtil.trim((String)restrictedClassName)))) continue;
                try {
                    this._restrictedClasses.add(aggregateClassLoader.loadClass(restrictedClassName));
                }
                catch (ClassNotFoundException cnfe) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((String[])new String[]{"Unable to find restricted class ", restrictedClassName, ". Registering as a package."}), (Throwable)cnfe);
                    }
                    this._restrictedPackageNames.add(restrictedClassName);
                }
            }
        }
    }

    @Override
    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof TemplateModel) {
            return (TemplateModel)object;
        }
        Class<?> clazz = object.getClass();
        String className = clazz.getName();
        if (!this._allowAllClasses) {
            this._checkClassIsRestricted(clazz);
        }
        if (this._restrictedMethodNames.containsKey(className)) {
            LiferayFreeMarkerBeanModel liferayFreeMarkerBeanModel = (LiferayFreeMarkerBeanModel)_LIFERAY_FREEMARKER_BEAN_MODEL_FACTORY.create(object, this);
            liferayFreeMarkerBeanModel.setRestrictedMethodNames(this._restrictedMethodNames.get(className));
            return liferayFreeMarkerBeanModel;
        }
        if (className.startsWith("com.liferay.")) {
            if (object instanceof TemplateNode) {
                return new LiferayTemplateModel((TemplateNode)object, (ObjectWrapper)this);
            }
            if (object instanceof Collection) {
                return new SimpleSequence((Collection)object, (ObjectWrapper)this);
            }
            if (object instanceof Map) {
                return new MapModel((Map)object, (BeansWrapper)this);
            }
            return _STRING_MODEL_FACTORY.create(object, this);
        }
        ModelFactory modelFactory = _modelFactories.get(clazz);
        if (modelFactory != null) {
            return modelFactory.create(object, this);
        }
        return super.wrap(object);
    }

    @Override
    protected TemplateModel handleUnknownType(Object object) {
        ModelFactory modelFactory = null;
        modelFactory = object instanceof Enumeration ? _ENUMERATION_MODEL_FACTORY : (object instanceof Node ? _NODE_MODEL_FACTORY : (object instanceof ResourceBundle ? _RESOURCE_BUNDLE_MODEL_FACTORY : _STRING_MODEL_FACTORY));
        _modelFactories.put(object.getClass(), modelFactory);
        return modelFactory.create(object, this);
    }

    private void _checkClassIsRestricted(Class<?> clazz) throws TemplateModelException {
        ClassRestrictionInformation classRestrictionInformation = this._classRestrictionInformations.computeIfAbsent(clazz.getName(), className -> {
            if (this._allowedClassNames.contains(className)) {
                return _nullInstance;
            }
            for (Class<?> restrictedClass : this._restrictedClasses) {
                if (!restrictedClass.isAssignableFrom(clazz)) continue;
                return new ClassRestrictionInformation(StringBundler.concat((String[])new String[]{"Denied resolving class ", className, " by ", restrictedClass.getName()}));
            }
            int index = className.lastIndexOf(".");
            if (index == -1) {
                return _nullInstance;
            }
            String packageName = className.substring(0, index);
            packageName = packageName.concat(".");
            for (String restrictedPackageName : this._restrictedPackageNames) {
                if (!packageName.startsWith(restrictedPackageName)) continue;
                return new ClassRestrictionInformation(StringBundler.concat((String[])new String[]{"Denied resolving class ", className, " by ", restrictedPackageName}));
            }
            return _nullInstance;
        });
        if (classRestrictionInformation.isRestricted()) {
            throw new TemplateModelException(classRestrictionInformation.getDescription());
        }
    }

    static {
        _modelFactories = new ConcurrentReferenceKeyHashMap(FinalizeManager.SOFT_REFERENCE_FACTORY);
        _nullInstance = new ClassRestrictionInformation(null);
        try {
            ClassLoader classLoader = DefaultObjectWrapper.class.getClassLoader();
            _cacheClassNamesField = ReflectionUtil.getDeclaredField(classLoader.loadClass("freemarker.ext.beans.ClassIntrospector"), (String)"cacheClassNames");
            _classIntrospectorField = ReflectionUtil.getDeclaredField(BeansWrapper.class, (String)"classIntrospector");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ClassRestrictionInformation {
        private final String _description;

        public String getDescription() {
            return this._description;
        }

        public boolean isRestricted() {
            return this._description != null;
        }

        private ClassRestrictionInformation(String description) {
            this._description = description;
        }
    }
}

