/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplatePortletPreferences;
import com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration;
import com.liferay.portal.template.freemarker.internal.FreeMarkerManager;
import com.liferay.portal.template.freemarker.internal.LiferayObjectConstructor;
import freemarker.ext.beans.BeansWrapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={FreeMarkerTemplateContextHelper.class, TemplateContextHelper.class})
public class FreeMarkerTemplateContextHelper
extends TemplateContextHelper {
    private volatile FreeMarkerEngineConfiguration _freeMarkerEngineConfiguration;
    private Set<String> _restrictedVariables;
    private final List<TemplateContextContributor> _templateContextContributors = new CopyOnWriteArrayList<TemplateContextContributor>();

    public Set<String> getRestrictedVariables() {
        return this._restrictedVariables;
    }

    public void prepare(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest) {
        Map ftlVariables;
        super.prepare(contextObjects, httpServletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            Theme theme = themeDisplay.getTheme();
            String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
            contextObjects.put("fullCssPath", StringBundler.concat((String[])new String[]{"/", servletContextName, theme.getFreeMarkerTemplateLoader(), theme.getCssPath()}));
            String fullTemplatesPath = StringBundler.concat((String[])new String[]{"/", servletContextName, theme.getFreeMarkerTemplateLoader(), theme.getTemplatesPath()});
            contextObjects.put("fullTemplatesPath", fullTemplatesPath);
            contextObjects.put("init", fullTemplatesPath + "/init.ftl");
        }
        if ((ftlVariables = (Map)httpServletRequest.getAttribute("FTL_VARIABLES")) != null) {
            for (Map.Entry entry : ftlVariables.entrySet()) {
                String key = (String)entry.getKey();
                if (!Validator.isNotNull((String)key)) continue;
                contextObjects.put(key, entry.getValue());
            }
        }
        for (TemplateContextContributor templateContextContributor : this._templateContextContributors) {
            templateContextContributor.prepare(contextObjects, httpServletRequest);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._freeMarkerEngineConfiguration = (FreeMarkerEngineConfiguration)ConfigurableUtil.createConfigurable(FreeMarkerEngineConfiguration.class, properties);
        this._restrictedVariables = SetUtil.fromArray((Object[])this._freeMarkerEngineConfiguration.restrictedVariables());
    }

    protected void populateExtraHelperUtilities(Map<String, Object> helperUtilities) {
        BeansWrapper beansWrapper = FreeMarkerManager.getBeansWrapper();
        helperUtilities.put("enumUtil", beansWrapper.getEnumModels());
        helperUtilities.put("objectUtil", new LiferayObjectConstructor());
        helperUtilities.put("freeMarkerPortletPreferences", new TemplatePortletPreferences());
        helperUtilities.put("staticUtil", beansWrapper.getStaticModels());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(type=GLOBAL)")
    protected void registerTemplateContextContributor(TemplateContextContributor templateContextContributor) {
        this._templateContextContributors.add(templateContextContributor);
    }

    protected void unregisterTemplateContextContributor(TemplateContextContributor templateContextContributor) {
        this._templateContextContributors.remove(templateContextContributor);
    }
}

