/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.template.BaseTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import freemarker.core.ParseException;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelWithAPISupport;
import freemarker.template.WrappingTemplateModel;
import freemarker.template.utility.ObjectWrapperWithAPISupport;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class FreeMarkerTemplate
extends BaseTemplate {
    private static final TemplateModel _NULL_TEMPLATE_MODEL = new TemplateModel(){};
    private final Configuration _configuration;
    private final TemplateResourceCache _templateResourceCache;

    public FreeMarkerTemplate(TemplateResource templateResource, Map<String, Object> context, Configuration configuration, TemplateContextHelper templateContextHelper, TemplateResourceCache templateResourceCache) {
        super(templateResource, context, templateContextHelper);
        this._configuration = configuration;
        this._templateResourceCache = templateResourceCache;
        if (templateResourceCache.isEnabled()) {
            this.cacheTemplateResource(templateResourceCache, templateResource);
        }
    }

    protected void handleException(TemplateResource templateResource, TemplateResource errorTemplateResource, Exception exception, Writer writer) throws com.liferay.portal.kernel.template.TemplateException {
        if (this._templateResourceCache.isEnabled()) {
            this.cacheTemplateResource(this._templateResourceCache, errorTemplateResource);
        }
        if (exception instanceof TemplateException || exception instanceof ParseException) {
            this.put("exception", exception.getMessage());
            if (templateResource instanceof StringTemplateResource) {
                StringTemplateResource stringTemplateResource = (StringTemplateResource)templateResource;
                this.put("script", stringTemplateResource.getContent());
            }
            if (exception instanceof ParseException) {
                ParseException pe = (ParseException)exception;
                this.put("column", pe.getColumnNumber());
                this.put("line", pe.getLineNumber());
            }
            try {
                this.processTemplate(errorTemplateResource, writer);
            }
            catch (Exception e) {
                throw new com.liferay.portal.kernel.template.TemplateException("Unable to process FreeMarker template " + errorTemplateResource.getTemplateId(), (Throwable)e);
            }
        } else {
            throw new com.liferay.portal.kernel.template.TemplateException("Unable to process FreeMarker template " + templateResource.getTemplateId(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        TemplateResourceThreadLocal.setTemplateResource((String)"ftl", (TemplateResource)templateResource);
        try {
            Template template = this._configuration.getTemplate(this.getTemplateResourceUUID(templateResource), "UTF-8");
            template.process(new CachableDefaultMapAdapter(this.context, template.getObjectWrapper()), writer);
        }
        finally {
            TemplateResourceThreadLocal.setTemplateResource((String)"ftl", null);
        }
    }

    private class CachableDefaultMapAdapter
    extends WrappingTemplateModel
    implements TemplateHashModelEx,
    AdapterTemplateModel,
    WrapperTemplateModel,
    TemplateModelWithAPISupport,
    Serializable {
        private final Map<String, Object> _map;
        private final ObjectWrapper _objectWrapper;
        private final Map<String, TemplateModel> _wrappedValueMap;

        @Override
        public TemplateModel get(String key) throws TemplateModelException {
            TemplateModel templateModel = this._wrappedValueMap.get(key);
            if (templateModel == _NULL_TEMPLATE_MODEL) {
                return null;
            }
            if (templateModel != null) {
                return templateModel;
            }
            Object value = this._map.get(key);
            if (value == null) {
                this._wrappedValueMap.put(key, _NULL_TEMPLATE_MODEL);
                return null;
            }
            templateModel = this._objectWrapper.wrap(value);
            this._wrappedValueMap.put(key, templateModel);
            return templateModel;
        }

        @Override
        public Object getAdaptedObject(Class hint) {
            return this._map;
        }

        @Override
        public TemplateModel getAPI() throws TemplateModelException {
            return ((ObjectWrapperWithAPISupport)this._objectWrapper).wrapAsAPI(this._map);
        }

        @Override
        public Object getWrappedObject() {
            return this._map;
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public TemplateCollectionModel keys() {
            return new SimpleCollection(this._map.keySet(), this._objectWrapper);
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public TemplateCollectionModel values() {
            return new SimpleCollection(this._map.values(), this._objectWrapper);
        }

        private CachableDefaultMapAdapter(Map<String, Object> map, ObjectWrapper objectWrapper) {
            super(objectWrapper);
            this._map = map;
            this._objectWrapper = objectWrapper;
            this._wrappedValueMap = new HashMap<String, TemplateModel>();
        }
    }
}

