/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.JSPSupportServlet;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.template.BaseTemplateManager;
import com.liferay.portal.template.RestrictedTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration;
import com.liferay.portal.template.freemarker.internal.FreeMarkerBundleClassloader;
import com.liferay.portal.template.freemarker.internal.FreeMarkerTemplate;
import com.liferay.portal.template.freemarker.internal.FreeMarkerTemplateContextHelper;
import com.liferay.portal.template.freemarker.internal.FreeMarkerTemplateResourceCache;
import com.liferay.portal.template.freemarker.internal.FreeMarkerTemplateResourceLoader;
import com.liferay.portal.template.freemarker.internal.LiferayObjectWrapper;
import com.liferay.portal.template.freemarker.internal.LiferayTemplateCache;
import com.liferay.portal.template.freemarker.internal.UnsyncStringWriterFactory;
import freemarker.core.TemplateClassResolver;
import freemarker.debug.impl.DebuggerService;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.jsp.internal.WriterFactoryUtil;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"language.type=ftl"}, service={TemplateManager.class})
public class FreeMarkerManager
extends BaseTemplateManager {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerManager.class);
    private static final Map<ClassLoader, BeansWrapper> _beansWrappers = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final Function<InvocationHandler, ServletContext> _servletContextProxyProviderFunction = ProxyUtil.getProxyProviderFunction((Class[])new Class[]{ServletContext.class});
    private Bundle _bundle;
    private BundleTracker<Set<String>> _bundleTracker;
    private volatile int _bundleTrackingCount = -2;
    private Configuration _configuration;
    private volatile FreeMarkerBundleClassloader _freeMarkerBundleClassloader;
    private volatile FreeMarkerEngineConfiguration _freeMarkerEngineConfiguration;
    @Reference
    private FreeMarkerTemplateResourceCache _freeMarkerTemplateResourceCache;
    private SingleVMPool _singleVMPool;
    private final Map<String, String> _taglibMappings = new ConcurrentHashMap<String, String>();
    private TemplateClassResolver _templateClassResolver;
    private final Map<String, TemplateModel> _templateModels = new ConcurrentHashMap<String, TemplateModel>();

    public static BeansWrapper getBeansWrapper() {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        BeansWrapper beansWrapper = _beansWrappers.get(classLoader);
        if (beansWrapper == null) {
            BeansWrapperBuilder beansWrapperBuilder = new BeansWrapperBuilder(Configuration.getVersion());
            beansWrapper = beansWrapperBuilder.build();
            _beansWrappers.put(classLoader, beansWrapper);
        }
        return beansWrapper;
    }

    public void addStaticClassSupport(Map<String, Object> contextObjects, String variableName, Class<?> variableClass) {
        block2: {
            try {
                BeansWrapper beansWrapper = FreeMarkerManager.getBeansWrapper();
                TemplateHashModel templateHashModel = beansWrapper.getStaticModels();
                TemplateModel templateModel = templateHashModel.get(variableClass.getName());
                contextObjects.put(variableName, templateModel);
            }
            catch (TemplateModelException tme) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Variable " + variableName + " registration fail"), (Throwable)tme);
            }
        }
    }

    public void addTaglibApplication(Map<String, Object> contextObjects, String applicationName, ServletContext servletContext) {
        contextObjects.put(applicationName, this.getServletContextHashModel(servletContext));
    }

    public void addTaglibFactory(Map<String, Object> contextObjects, String taglibFactoryName, ServletContext servletContext) {
        contextObjects.put(taglibFactoryName, new TaglibFactoryWrapper(servletContext));
    }

    public void addTaglibRequest(Map<String, Object> contextObjects, String applicationName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        contextObjects.put(applicationName, new HttpRequestHashModel(httpServletRequest, httpServletResponse, this._configuration.getObjectWrapper()));
    }

    public void addTaglibSupport(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ServletContext servletContext = httpServletRequest.getServletContext();
        this.addTaglibApplication(contextObjects, "Application", servletContext);
        this.addTaglibRequest(contextObjects, "Request", httpServletRequest, httpServletResponse);
        TaglibFactoryWrapper taglibFactoryWrapper = new TaglibFactoryWrapper(servletContext);
        contextObjects.put("PortalJspTagLibs", taglibFactoryWrapper);
        contextObjects.put("PortletJspTagLibs", taglibFactoryWrapper);
        contextObjects.put("taglibLiferayHash", taglibFactoryWrapper);
        for (Map.Entry<String, String> entry : this._taglibMappings.entrySet()) {
            try {
                contextObjects.put(entry.getKey(), taglibFactoryWrapper.get(entry.getValue()));
            }
            catch (TemplateModelException tme) {
                _log.error((Object)("Unable to add taglib " + entry.getKey() + " to context"), (Throwable)tme);
            }
        }
    }

    public void destroy() {
        if (this._configuration == null) {
            return;
        }
        this._configuration.clearEncodingMap();
        this._configuration.clearSharedVariables();
        this._configuration.clearTemplateCache();
        this._configuration = null;
        this.templateContextHelper.removeAllHelperUtilities();
        this._templateModels.clear();
        if (this.isEnableDebuggerService()) {
            // empty if block
        }
    }

    public void destroy(ClassLoader classLoader) {
        this.templateContextHelper.removeHelperUtilities(classLoader);
    }

    public String getName() {
        return "ftl";
    }

    public String[] getRestrictedVariables() {
        return this._freeMarkerEngineConfiguration.restrictedVariables();
    }

    public void init() throws TemplateException {
        if (this._configuration != null) {
            return;
        }
        this._configuration = new Configuration(Configuration.getVersion());
        try {
            Field field = ReflectionUtil.getDeclaredField(Configuration.class, (String)"cache");
            PortalCache portalCache = null;
            if (this._freeMarkerTemplateResourceCache.isEnabled()) {
                portalCache = this._singleVMPool.getPortalCache(StringBundler.concat((String[])new String[]{TemplateResource.class.getName(), "#", "ftl"}));
                this._freeMarkerTemplateResourceCache.setSecondLevelPortalCache(portalCache);
            }
            LiferayTemplateCache templateCache = new LiferayTemplateCache(this._configuration, this.templateResourceLoader, portalCache);
            field.set(this._configuration, templateCache);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to Initialize FreeMarker manager", (Throwable)e);
        }
        this._configuration.setDefaultEncoding("UTF-8");
        this._configuration.setLocalizedLookup(this._freeMarkerEngineConfiguration.localizedLookup());
        this._configuration.setNewBuiltinClassResolver(this._templateClassResolver);
        this._configuration.setObjectWrapper(new LiferayObjectWrapper(this._freeMarkerEngineConfiguration.allowedClasses(), this._freeMarkerEngineConfiguration.restrictedClasses(), this._freeMarkerEngineConfiguration.restrictedMethods()));
        try {
            this._configuration.setSetting("auto_import", this._getMacroLibrary());
            this._configuration.setSetting("template_exception_handler", this._freeMarkerEngineConfiguration.templateExceptionHandler());
        }
        catch (Exception e) {
            throw new TemplateException("Unable to init FreeMarker manager", (Throwable)e);
        }
        if (this.isEnableDebuggerService()) {
            DebuggerService.getBreakpoints("*");
        }
    }

    @Reference(unbind="-")
    public void setTemplateClassResolver(TemplateClassResolver templateClassResolver) {
        this._templateClassResolver = templateClassResolver;
    }

    @Reference(service=FreeMarkerTemplateContextHelper.class, unbind="-")
    public void setTemplateContextHelper(TemplateContextHelper templateContextHelper) {
        super.setTemplateContextHelper(templateContextHelper);
    }

    @Reference(service=FreeMarkerTemplateResourceLoader.class, unbind="-")
    public void setTemplateResourceLoader(TemplateResourceLoader templateResourceLoader) {
        super.setTemplateResourceLoader(templateResourceLoader);
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext) {
        this._freeMarkerEngineConfiguration = (FreeMarkerEngineConfiguration)ConfigurableUtil.createConfigurable(FreeMarkerEngineConfiguration.class, (Dictionary)componentContext.getProperties());
        BundleContext bundleContext = componentContext.getBundleContext();
        this._bundle = bundleContext.getBundle();
        int stateMask = 36;
        this._bundleTracker = new BundleTracker(bundleContext, stateMask, (BundleTrackerCustomizer)new TaglibBundleTrackerCustomizer());
        this._bundleTracker.open();
        WriterFactoryUtil.setWriterFactory(new UnsyncStringWriterFactory());
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    protected Template doGetTemplate(TemplateResource templateResource, boolean restricted, Map<String, Object> helperUtilities) {
        FreeMarkerTemplate template = new FreeMarkerTemplate(templateResource, helperUtilities, this._configuration, this.templateContextHelper, (TemplateResourceCache)this._freeMarkerTemplateResourceCache);
        if (restricted) {
            template = new RestrictedTemplate((Template)template, this.templateContextHelper.getRestrictedVariables());
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FreeMarkerBundleClassloader getFreeMarkerBundleClassloader() {
        BundleTracker<Set<String>> bundleTracker = this._bundleTracker;
        synchronized (bundleTracker) {
            int currentCount = this._bundleTracker.getTrackingCount();
            if (currentCount <= this._bundleTrackingCount && this._freeMarkerBundleClassloader != null) {
                return this._freeMarkerBundleClassloader;
            }
            this._bundleTrackingCount = currentCount;
            Bundle[] bundles = this._bundleTracker.getBundles();
            if (bundles == null) {
                bundles = new Bundle[]{this._bundle};
            } else {
                Bundle[] tempBundles = new Bundle[bundles.length + 1];
                tempBundles[0] = this._bundle;
                System.arraycopy(bundles, 0, tempBundles, 1, bundles.length);
                bundles = tempBundles;
            }
            this._freeMarkerBundleClassloader = new FreeMarkerBundleClassloader(bundles);
            return this._freeMarkerBundleClassloader;
        }
    }

    protected ServletContextHashModel getServletContextHashModel(ServletContext servletContext) {
        JSPSupportServlet genericServlet = new JSPSupportServlet(servletContext);
        return new ServletContextHashModel((GenericServlet)genericServlet, this._configuration.getObjectWrapper());
    }

    protected ServletContext getServletContextWrapper(ServletContext servletContext, FreeMarkerBundleClassloader freeMarkerBundleClassloader) {
        return _servletContextProxyProviderFunction.apply(new ServletContextInvocationHandler(servletContext, freeMarkerBundleClassloader));
    }

    protected boolean isEnableDebuggerService() {
        return System.getProperty("freemarker.debug.password") != null && System.getProperty("freemarker.debug.port") != null;
    }

    @Reference(unbind="-")
    protected void setSingleVMPool(SingleVMPool singleVMPool) {
        this._singleVMPool = singleVMPool;
    }

    private String _getMacroLibrary() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String contextName = ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader());
        contextName = contextName.concat("_CLASS_LOADER_CONTEXT_");
        String[] macroLibrary = this._freeMarkerEngineConfiguration.macroLibrary();
        StringBundler sb = new StringBundler(3 * macroLibrary.length);
        for (String library : macroLibrary) {
            sb.append(contextName);
            sb.append(library);
            sb.append(",");
        }
        if (macroLibrary.length > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private class TaglibFactoryWrapper
    implements TemplateHashModel {
        private final FreeMarkerBundleClassloader _freeMarkerBundleClassloader;
        private final TaglibFactory _taglibFactory;

        public TaglibFactoryWrapper(ServletContext servletContext) {
            this._freeMarkerBundleClassloader = FreeMarkerManager.this.getFreeMarkerBundleClassloader();
            this._taglibFactory = new TaglibFactory(FreeMarkerManager.this.getServletContextWrapper(servletContext, this._freeMarkerBundleClassloader));
            this._taglibFactory.setObjectWrapper(FreeMarkerManager.getBeansWrapper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateModel get(String uri) throws TemplateModelException {
            TemplateModel templateModel = (TemplateModel)FreeMarkerManager.this._templateModels.get(uri);
            if (templateModel == null) {
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this._freeMarkerBundleClassloader);
                    templateModel = this._taglibFactory.get(uri);
                }
                finally {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
                FreeMarkerManager.this._templateModels.put(uri, templateModel);
            }
            return templateModel;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private class TaglibBundleTrackerCustomizer
    implements BundleTrackerCustomizer<Set<String>> {
        private TaglibBundleTrackerCustomizer() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set<String> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            URL url = bundle.getEntry("/META-INF/taglib-mappings.properties");
            if (url == null) {
                BundleCapability bundleCapability;
                Map attributes;
                Object value;
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                List bundleCapabilities = bundleWiring.getCapabilities("osgi.extender");
                Iterator iterator = bundleCapabilities.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while (!(value = (attributes = (bundleCapability = (BundleCapability)iterator.next()).getAttributes()).get("osgi.extender")).equals("jsp.taglib"));
                return Collections.emptySet();
            }
            try (InputStream inputStream = url.openStream();){
                Properties properties = PropertiesUtil.load((InputStream)inputStream, (String)"UTF-8");
                Map map = PropertiesUtil.toMap((Properties)properties);
                FreeMarkerManager.this._taglibMappings.putAll(map);
                Set<String> set = map.keySet();
                return set;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Set<String> trackedKeys) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Set<String> trackedKeys) {
            for (String key : trackedKeys) {
                FreeMarkerManager.this._taglibMappings.remove(key);
            }
            FreeMarkerManager.this._templateModels.clear();
        }
    }

    private class ServletContextInvocationHandler
    implements InvocationHandler {
        private final FreeMarkerBundleClassloader _freeMarkerBundleClassloader;
        private final ServletContext _servletContext;

        public ServletContextInvocationHandler(ServletContext servletContext, FreeMarkerBundleClassloader freeMarkerBundleClassloader) {
            this._servletContext = servletContext;
            this._freeMarkerBundleClassloader = freeMarkerBundleClassloader;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getClassLoader")) {
                return this._freeMarkerBundleClassloader;
            }
            if (methodName.equals("getResource")) {
                return this._getResource((String)args[0]);
            }
            if (methodName.equals("getResourceAsStream")) {
                return this._getResourceAsStream((String)args[0]);
            }
            if (methodName.equals("getResourcePaths")) {
                return this._getResourcePaths((String)args[0]);
            }
            return method.invoke((Object)this._servletContext, args);
        }

        private URL _getExtension(String path) {
            Enumeration enumeration = FreeMarkerManager.this._bundle.findEntries("META-INF/resources", path.substring(1), false);
            if (enumeration == null) {
                return null;
            }
            ArrayList urls = Collections.list(enumeration);
            return (URL)urls.get(urls.size() - 1);
        }

        private URL _getResource(String path) {
            String adaptedPath;
            URL url;
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
            if ((url = this._getExtension(path)) != null) {
                return url;
            }
            url = this._freeMarkerBundleClassloader.getResource(path);
            if (url != null) {
                return url;
            }
            if (path.startsWith("/WEB-INF/tld/") && (url = this._getExtension(adaptedPath = "/META-INF/" + path.substring("/WEB-INF/tld/".length()))) == null) {
                url = FreeMarkerManager.this._bundle.getResource(adaptedPath);
            }
            if (url != null) {
                return url;
            }
            if (!path.startsWith("/META-INF/") && !path.startsWith("/WEB-INF/")) {
                url = FreeMarkerManager.this._bundle.getResource("/META-INF/resources" + path);
            }
            return url;
        }

        private InputStream _getResourceAsStream(String path) {
            URL url = this._getResource(path);
            if (url == null) {
                return null;
            }
            try {
                return url.openStream();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        private Set<String> _getResourcePaths(String path) {
            Enumeration entries = FreeMarkerManager.this._bundle.findEntries(path, null, true);
            if (entries == null) {
                return null;
            }
            HashSet<String> resourcePaths = new HashSet<String>();
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                resourcePaths.add(url.getPath());
            }
            return resourcePaths;
        }
    }
}

