/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;

public class FreeMarkerBundleClassloader
extends URLClassLoader {
    private final Set<Bundle> _bundles = ConcurrentHashMap.newKeySet();

    public FreeMarkerBundleClassloader(Bundle ... bundles) {
        super(new URL[0]);
        if (bundles.length == 0) {
            throw new IllegalArgumentException("Bundles are empty");
        }
        Collections.addAll(this._bundles, bundles);
    }

    @Override
    public URL findResource(String name) {
        for (Bundle bundle : this._bundles) {
            URL url = bundle.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        for (Bundle bundle : this._bundles) {
            try {
                Enumeration enumeration = bundle.getResources(name);
                if (enumeration == null || !enumeration.hasMoreElements()) continue;
                return enumeration;
            }
            catch (IOException iOException) {
            }
        }
        return Collections.enumeration(Collections.emptyList());
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.findResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (Bundle bundle : this._bundles) {
            try {
                return bundle.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

