/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.target.platform.indexer.internal;

import com.liferay.portal.target.platform.indexer.internal.PathUtil;
import com.liferay.portal.target.platform.indexer.internal.TargetPlatformIndexer;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class TargetPlatformIndexerUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void indexTargetPlatform(OutputStream outputStream, List<File> additionalJarFiles, long stopWaitTimeout, String ... dirNames) throws Exception {
        Framework framework = null;
        Path tempPath = Files.createTempDirectory(null, new FileAttribute[0]);
        ClassLoader classLoader = TargetPlatformIndexerUtil.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("META-INF/system.packages.extra.mf");){
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("org.osgi.framework.storage", tempPath.toString());
            Manifest extraPackagesManifest = new Manifest(inputStream);
            Attributes attributes = extraPackagesManifest.getMainAttributes();
            properties.put("org.osgi.framework.system.capabilities.extra", attributes.getValue("Provide-Capability"));
            properties.put("org.osgi.framework.system.packages.extra", attributes.getValue("Export-Package"));
            ServiceLoader<FrameworkFactory> serviceLoader = ServiceLoader.load(FrameworkFactory.class);
            Iterator<FrameworkFactory> iterator = serviceLoader.iterator();
            FrameworkFactory frameworkFactory = iterator.next();
            framework = frameworkFactory.newFramework(properties);
            framework.init();
            BundleContext bundleContext = framework.getBundleContext();
            Bundle systemBundle = bundleContext.getBundle(0L);
            TargetPlatformIndexer targetPlatformIndexer = new TargetPlatformIndexer(systemBundle, additionalJarFiles, dirNames);
            targetPlatformIndexer.index(outputStream);
        }
        finally {
            if (framework != null) {
                framework.stop();
                FrameworkEvent frameworkEvent = framework.waitForStop(stopWaitTimeout);
                if (frameworkEvent.getType() == 512) {
                    throw new Exception("OSGi framework event " + frameworkEvent + " triggered after a " + stopWaitTimeout + "ms timeout");
                }
            }
            PathUtil.deltree(tempPath);
        }
    }
}

