/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.target.platform.indexer.internal;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.repository.SimpleIndexer;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import com.liferay.portal.target.platform.indexer.Indexer;
import com.liferay.portal.target.platform.indexer.internal.PathUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;

public class TargetPlatformIndexer
implements Indexer {
    private static final String _ATTRIBUTE_PREFIX_OSGI_CONTENT = "<attribute name=\"osgi.content\" value=\"";
    private static final String _ATTRIBUTE_PREFIX_SIZE = "<attribute name=\"size\" value=\"";
    private static final String _MAX_SUPPORTED_JAVA_SE_VERSION = "1.8.0";
    private static final String _PARAMETER_STRING_OS_VERSION = "eclipse.platform;osgi.os=linux;osgi.arch=x86_64;osgi.ws=gtk;osgi.nl=en_US";
    private static final Set<String> _ignoredNamespaces = new HashSet<String>(Arrays.asList("osgi.wiring.bundle", "osgi.content", "osgi.wiring.host", "osgi.identity", "osgi.native", "osgi.wiring.package"));
    private final List<File> _additionalJarFiles;
    private final String[] _dirNames;
    private final Parameters _packagesParamters = new Parameters();
    private final List<Parameters> _parametersList = new ArrayList<Parameters>();
    private final Bundle _systemBundle;

    public TargetPlatformIndexer(Bundle systemBundle, List<File> additionalJarFiles, String ... dirNames) {
        this._systemBundle = systemBundle;
        this._additionalJarFiles = additionalJarFiles;
        this._dirNames = dirNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(OutputStream outputStream) throws Exception {
        Path tempPath = Files.createTempDirectory(null, new FileAttribute[0]);
        File tempDir = tempPath.toFile();
        LinkedHashSet<File> jarFiles = new LinkedHashSet<File>();
        try {
            Object[] objects = this._processSystemBundle(tempDir, jarFiles);
            String crc32 = (String)objects[0];
            int size = (Integer)objects[1];
            for (String dirName : this._dirNames) {
                Path path = Paths.get(dirName, new String[0]);
                if (Files.notExists(path, new LinkOption[0])) continue;
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "*.jar");){
                    Iterator<Path> iterator = directoryStream.iterator();
                    while (iterator.hasNext()) {
                        this._addBundle(tempPath, iterator.next(), jarFiles);
                    }
                }
            }
            for (File additionalJarFile : this._additionalJarFiles) {
                Path tempJarPath = tempPath.resolve(additionalJarFile.getName());
                Files.copy(additionalJarFile.toPath(), tempJarPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                jarFiles.add(tempJarPath.toFile());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SimpleIndexer simpleIndexer = new SimpleIndexer();
            simpleIndexer.base(tempPath.toUri());
            simpleIndexer.compress(false);
            simpleIndexer.files(jarFiles);
            simpleIndexer.increment(1L);
            simpleIndexer.name("Liferay Target Platform");
            simpleIndexer.index(byteArrayOutputStream);
            outputStream.write(this._fixSystemBundleOSGiContent(byteArrayOutputStream.toString("UTF-8"), crc32, size));
        }
        finally {
            PathUtil.deltree(tempPath);
        }
    }

    private static String _filterJavaSEVesions(String versions) {
        StringBuilder sb = new StringBuilder(versions.length());
        for (String version : versions.split(",")) {
            if (version.compareTo(_MAX_SUPPORTED_JAVA_SE_VERSION) > 0) continue;
            sb.append(version);
            sb.append(",");
        }
        if (sb.length() != 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private void _addBundle(Path tempPath, Path jarPath, Set<File> jarFiles) throws IOException {
        if (!Files.exists(jarPath, new LinkOption[0])) {
            return;
        }
        Path tempJarPath = tempPath.resolve(URLEncoder.encode(String.valueOf(jarPath.getFileName()), "UTF-8"));
        Files.copy(jarPath, tempJarPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        jarFiles.add(tempJarPath.toFile());
    }

    private byte[] _fixSystemBundleOSGiContent(String content, String crc32, long size) throws UnsupportedEncodingException {
        String url = this._systemBundle.getSymbolicName() + "-" + this._systemBundle.getVersion() + ".jar";
        int index = content.indexOf(url);
        if (index == -1) {
            throw new IllegalStateException("Indexed content:\n" + content + "\nMissing system bundle URL: " + url);
        }
        int start = content.indexOf(_ATTRIBUTE_PREFIX_OSGI_CONTENT, index);
        if (start == -1) {
            throw new IllegalStateException("Indexed content:\n" + content.substring(0, index) + "\nMissing OSGI content attribute: " + _ATTRIBUTE_PREFIX_OSGI_CONTENT);
        }
        int end = content.indexOf("\"/>", start += _ATTRIBUTE_PREFIX_OSGI_CONTENT.length());
        String prefix = content.substring(0, start);
        String postfix = content.substring(end);
        String newContent = prefix.concat(crc32).concat(postfix);
        start = newContent.lastIndexOf(_ATTRIBUTE_PREFIX_SIZE, index = newContent.indexOf(url));
        if (start == -1) {
            throw new IllegalStateException("Indexed content:\n" + content + "\nMissing size attribute: " + _ATTRIBUTE_PREFIX_SIZE);
        }
        end = newContent.indexOf("\" t", start += _ATTRIBUTE_PREFIX_SIZE.length());
        prefix = newContent.substring(0, start);
        postfix = newContent.substring(end);
        newContent = prefix.concat(String.valueOf(size)).concat(postfix);
        newContent = newContent.replace("\r\n", "\n");
        return newContent.getBytes("UTF-8");
    }

    private void _processBundle(Bundle bundle) throws Exception {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        for (Capability capability : bundleRevision.getCapabilities(null)) {
            String namespace = capability.getNamespace();
            CapabilityBuilder capabilityBuilder = new CapabilityBuilder(namespace);
            capabilityBuilder.addAttributes(capability.getAttributes());
            capabilityBuilder.addDirectives(capability.getDirectives());
            Attrs attrs = capabilityBuilder.toAttrs();
            if (capabilityBuilder.isPackage()) {
                attrs.remove("bundle-symbolic-name");
                attrs.remove("bundle-version");
                String packageName = attrs.remove("osgi.wiring.package");
                if (packageName == null) continue;
                this._packagesParamters.put(packageName, attrs);
                continue;
            }
            if (_ignoredNamespaces.contains(namespace)) continue;
            Parameters parameters = new Parameters();
            if (namespace.equals("osgi.native")) {
                LinkedHashSet<String> keys = new LinkedHashSet<String>(attrs.keySet());
                for (String key : keys) {
                    if (key.startsWith("osgi.native")) continue;
                    attrs.remove(key);
                }
            }
            parameters.put(namespace, attrs);
            this._parametersList.add(parameters);
        }
    }

    /*
     * Exception decompiling
     */
    private Object[] _processSystemBundle(File tempDir, Set<File> jarFiles) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

