/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.target.platform.indexer.internal;

import aQute.bnd.osgi.repository.SimpleIndexer;
import com.liferay.portal.target.platform.indexer.Indexer;
import com.liferay.portal.target.platform.indexer.internal.PathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LPKGIndexer
implements Indexer {
    private static final Pattern _pattern = Pattern.compile("(.*?)(-\\d+\\.\\d+\\.\\d+)(\\.jar)");
    private final Set<String> _excludedJarFileNames;
    private final File _lpkgFile;

    public LPKGIndexer(File lpkgFile, Set<String> excludedJarFileNames) {
        this._lpkgFile = lpkgFile;
        this._excludedJarFileNames = excludedJarFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(OutputStream outputStream) throws Exception {
        if (this._excludedJarFileNames.isEmpty() && this._readCachedIndex(outputStream)) {
            return;
        }
        Path tempPath = Files.createTempDirectory(null, new FileAttribute[0]);
        File tempDir = tempPath.toFile();
        try (ZipFile zipFile = new ZipFile(this._lpkgFile);){
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean hasExcludedJarFile = false;
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.endsWith(".jar")) continue;
                if (this._excludedJarFileNames.contains(this._toExcludedJarFileName(name))) {
                    hasExcludedJarFile = true;
                    continue;
                }
                File file = new File(tempDir, name);
                Files.copy(zipFile.getInputStream(zipEntry), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                files.add(file);
            }
            if (!hasExcludedJarFile && this._readCachedIndex(outputStream)) {
                return;
            }
            SimpleIndexer simpleIndexer = new SimpleIndexer();
            simpleIndexer.base(tempDir.toURI());
            simpleIndexer.compress(false);
            simpleIndexer.files(files);
            simpleIndexer.increment(1L);
            simpleIndexer.name(this._getRepositoryName(this._lpkgFile));
            simpleIndexer.index(outputStream);
        }
        finally {
            PathUtil.deltree(tempPath);
        }
    }

    private String _getRepositoryName(File lpkgFile) {
        String fileName = lpkgFile.getName();
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    private boolean _readCachedIndex(OutputStream outputStream) throws IOException {
        block26: {
            try (ZipFile zipFile = new ZipFile(this._lpkgFile);){
                ZipEntry zipEntry = zipFile.getEntry("index.xml");
                if (zipEntry == null) break block26;
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    this._transfer(inputStream, outputStream);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private String _toExcludedJarFileName(String name) {
        Matcher matcher = _pattern.matcher(name);
        if (matcher.matches()) {
            name = matcher.group(1) + matcher.group(3);
        }
        return name.toLowerCase();
    }

    private void _transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int value = -1;
        byte[] bytes = new byte[8192];
        while ((value = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, value);
        }
    }
}

