/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.target.platform.indexer.internal;

import aQute.bnd.build.model.EE;
import aQute.bnd.build.model.OSGI_CORE;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import biz.aQute.resolve.ResolverValidator;
import com.liferay.portal.target.platform.indexer.IndexValidator;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.osgi.resource.Resource;
import org.osgi.util.promise.PromiseFactory;

public class DefaultIndexValidator
implements IndexValidator {
    private static final String _MESSAGE_PREFIX = "Unable to resolve <<INITIAL>> version=null: ";
    private static final Field _field;
    private final List<URI> _targetPlatformIndexURIs;

    public DefaultIndexValidator(List<URI> targetPlatformIndexURIs) {
        this._targetPlatformIndexURIs = targetPlatformIndexURIs;
    }

    public List<String> validate(List<URI> indexURIs) throws Exception {
        HashSet<String> identities = new HashSet<String>();
        HashSet<Resource> resources = new HashSet<Resource>();
        for (URI uri : indexURIs) {
            URL url = uri.toURL();
            try (InputStream inputStream = url.openStream();){
                String identity = this._getRepositoryIdentity(uri.getPath(), inputStream);
                identities.add(identity);
            }
            resources.addAll(XMLResourceParser.getResources(uri));
        }
        try (ResolverValidator resolverValidator = new ResolverValidator();){
            ResourceBuilder resourceBuilder = new ResourceBuilder();
            resourceBuilder.addEE(EE.JavaSE_1_8);
            Domain domain = OSGI_CORE.R7_0_0.getManifest();
            resourceBuilder.addManifest(domain);
            this._includeSystemBundleAlias(resourceBuilder, domain);
            this._includeTargetPlatform(resourceBuilder, identities);
            resolverValidator.setSystem(resourceBuilder.build());
            List<ResolverValidator.Resolution> resolutions = resolverValidator.validate(resources);
            ArrayList<String> messages = new ArrayList<String>();
            for (ResolverValidator.Resolution resolution : resolutions) {
                String message;
                if (resolution.succeeded || (message = resolution.message) == null) continue;
                if (message.startsWith(_MESSAGE_PREFIX)) {
                    message = message.substring(_MESSAGE_PREFIX.length());
                }
                messages.add(message);
            }
            ArrayList<String> arrayList = messages;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getRepositoryIdentity(String path, InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        try (XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(inputStream);){
            while (xmlStreamReader.hasNext()) {
                String localName;
                int eventType = xmlStreamReader.next();
                if (eventType != 1 || !(localName = xmlStreamReader.getLocalName()).equals("repository")) continue;
                String string = xmlStreamReader.getAttributeValue(null, "name");
                return string;
            }
            String string = path;
            return string;
        }
    }

    private void _includeSystemBundleAlias(ResourceBuilder resourceBuilder, Domain domain) throws Exception {
        CapReqBuilder capability = new CapReqBuilder("osgi.wiring.bundle");
        capability.addAttribute(capability.getNamespace(), "system.bundle");
        Parameters parameters = domain.getExportPackage();
        Attrs attrs = parameters.get("org.osgi.framework");
        String version = attrs.get("version");
        capability.addAttribute(ResourceUtils.getVersionAttributeForNamespace(capability.getNamespace()), version);
        resourceBuilder.addCapability(capability);
        capability = new CapReqBuilder("osgi.wiring.host");
        capability.addAttribute(capability.getNamespace(), "system.bundle");
        capability.addAttribute(ResourceUtils.getVersionAttributeForNamespace(capability.getNamespace()), version);
        resourceBuilder.addCapability(capability);
        capability = new CapReqBuilder("osgi.identity");
        capability.addAttribute(capability.getNamespace(), "system.bundle");
        capability.addAttribute(ResourceUtils.getVersionAttributeForNamespace(capability.getNamespace()), version);
        capability.addAttribute("type", "osgi.bundle");
        resourceBuilder.addCapability(capability);
    }

    private void _includeTargetPlatform(ResourceBuilder resourceBuilder, Set<String> identities) throws Exception {
        for (URI uri : this._targetPlatformIndexURIs) {
            URL url = uri.toURL();
            InputStream inputStream = url.openStream();
            Throwable throwable = null;
            try {
                String identity = this._getRepositoryIdentity(uri.getPath(), inputStream);
                if (identities.contains(identity)) continue;
                identities.add(identity);
            }
            catch (Throwable identity) {
                throwable = identity;
                throw identity;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                inputStream.close();
                continue;
            }
            XMLResourceParser xmlResourceParser = new XMLResourceParser(uri);
            throwable = null;
            try {
                List<Resource> resources = xmlResourceParser.parse();
                for (Resource resource : resources) {
                    resourceBuilder.addCapabilities(resource.getCapabilities(null));
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (xmlResourceParser == null) continue;
                if (throwable != null) {
                    try {
                        xmlResourceParser.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                xmlResourceParser.close();
            }
        }
    }

    static {
        try {
            _field = Processor.class.getDeclaredField("promiseFactory");
            _field.setAccessible(true);
            _field.set(null, new PromiseFactory(null));
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Processor.getExecutor();
            threadPoolExecutor.setMaximumPoolSize(1);
            threadPoolExecutor.setThreadFactory(runnable -> {
                Thread thread = new Thread(runnable, "bnd-Processor-Thread");
                thread.setDaemon(true);
                return thread;
            });
        }
        catch (ReflectiveOperationException roe) {
            throw new ExceptionInInitializerError(roe);
        }
    }
}

