/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.libg.cryptography.SHA256;
import java.io.File;

public class WorkspaceResourcesRepository
extends ResourcesRepository {
    public static final String WORKSPACE_NAMESPACE = "bnd.workspace.project";

    public WorkspaceResourcesRepository(Workspace workspace) throws Exception {
        for (Project p : workspace.getAllProjects()) {
            File[] files = p.getBuildFiles(false);
            if (files == null) continue;
            for (File file : files) {
                Domain manifest = Domain.domain(file);
                ResourceBuilder rb = new ResourceBuilder();
                rb.addManifest(manifest);
                Attrs attrs = new Attrs();
                attrs.put("url", file.toURI().toString());
                attrs.putTyped("size", file.length());
                attrs.put("osgi.content", SHA256.digest(file).asHex());
                rb.addCapability(CapReqBuilder.createCapReqBuilder("osgi.content", attrs));
                attrs = new Attrs();
                attrs.put(WORKSPACE_NAMESPACE, p.getName());
                rb.addCapability(CapReqBuilder.createCapReqBuilder(WORKSPACE_NAMESPACE, attrs));
                this.add(rb.build());
            }
        }
    }

    public String toString() {
        return "Workspace";
    }
}

