/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResolutionDirective;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import biz.aQute.resolve.BndResolver;
import biz.aQute.resolve.BndrunResolveContext;
import biz.aQute.resolve.LogReporter;
import biz.aQute.resolve.ResolveProcess;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverValidator
extends Processor {
    private static final Logger logger = LoggerFactory.getLogger(ResolverValidator.class);
    private BndrunResolveContext _bndrunResolveContext;
    LogReporter reporter = new LogReporter(this);
    Resolver resolver = new BndResolver(this.reporter);
    List<URI> repositories = new ArrayList<URI>();
    Resource system = null;

    public ResolverValidator(Processor parent) throws Exception {
        super(parent);
    }

    public ResolverValidator() {
    }

    public void addRepository(URI url) throws Exception {
        this.repositories.add(url);
    }

    public void setSystem(Resource resource) throws Exception {
        assert (resource != null);
        this.system = resource;
    }

    /*
     * Exception decompiling
     */
    public List<Resolution> validate() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Resolution> validate(Collection<Resource> toBeChecked) throws Exception {
        LinkedHashSet<Resource> allResources = new LinkedHashSet<Resource>();
        for (URI uri : this.repositories) {
            allResources.addAll(XMLResourceParser.getResources(uri));
        }
        allResources.addAll(toBeChecked);
        ResourcesRepository repository = new ResourcesRepository(allResources);
        return this.validateResources(repository, toBeChecked);
    }

    public List<Resolution> validateResources(Repository repository, Collection<Resource> resources) throws Exception {
        this.setProperty("-runfw", "dummy");
        ArrayList<Resolution> result = new ArrayList<Resolution>();
        ArrayList<Resource> resourceList = new ArrayList<Resource>(resources);
        while (!resourceList.isEmpty()) {
            Resource resource = (Resource)resourceList.remove(0);
            Resolution resolution = this.resolve(repository, resource);
            result.add(resolution);
            for (Resource resolved : resolution.resolved) {
                if (!resourceList.remove(resolved)) continue;
                Resolution curResolution = new Resolution();
                curResolution.resource = resolved;
                curResolution.succeeded = true;
                result.add(curResolution);
            }
        }
        return result;
    }

    public static Set<Resource> getAllResources(Repository repository) {
        Requirement r = ResourceUtils.createWildcardRequirement();
        Map<Requirement, Collection<Capability>> providers = repository.findProviders(Collections.singleton(r));
        Set<Resource> resources = ResourceUtils.getResources(providers.get(r));
        return resources;
    }

    private BndrunResolveContext getResolveContext(Repository repository) throws Exception {
        BndrunResolveContext context = this._bndrunResolveContext;
        if (context == null) {
            context = new BndrunResolveContext(this, null, this, this.reporter){

                @Override
                void loadFramework(ResourceBuilder systemBuilder) throws Exception {
                    systemBuilder.addCapabilities(ResolverValidator.this.system.getCapabilities(null));
                }
            };
            context.addRepository(repository);
            context.init();
            this._bndrunResolveContext = context;
        } else {
            context.setInputResource(context.constructInputRequirements());
        }
        return context;
    }

    public Requirement getIdentity(Resource resource) {
        ResourceUtils.IdentityCapability identityCapability = ResourceUtils.getIdentityCapability(resource);
        return CapReqBuilder.createRequirementFromCapability(identityCapability).buildSyntheticRequirement();
    }

    public Resolution resolve(Repository repository, Resource resource) throws Exception {
        Resolution resolution = new Resolution();
        Requirement identity = this.getIdentity(resource);
        this.setProperty("-runrequires", ResourceUtils.toRequireCapability(identity));
        BndrunResolveContext context = this.getResolveContext(repository);
        resolution.resource = resource;
        try {
            Map<Resource, List<Wire>> resolve2 = this.resolver.resolve(context);
            resolution.succeeded = true;
            resolution.resolved = resolve2.keySet();
            logger.debug("resolving {} succeeded", (Object)resource);
        }
        catch (ResolutionException e) {
            logger.debug("resolving {} failed", (Object)resource);
            resolution.succeeded = false;
            resolution.message = e.getMessage();
            for (Requirement req : e.getUnresolvedRequirements()) {
                logger.debug("    missing {}", (Object)req);
                resolution.unresolved.add(req);
            }
            ResourcesRepository systemRepository = new ResourcesRepository(this.system);
            for (Requirement r : resource.getRequirements(null)) {
                Collection<Capability> caps = systemRepository.findProvider(r);
                boolean missing = caps.isEmpty();
                if (missing) {
                    Set<Requirement> requirements = Collections.singleton(r);
                    caps = repository.findProviders(requirements).get(r);
                    missing = caps.isEmpty();
                    if (missing) {
                        if (ResourceUtils.getResolution(r) == ResolutionDirective.optional) {
                            resolution.optionals.add(r);
                            continue;
                        }
                        resolution.missing.add(r);
                        continue;
                    }
                    logger.debug("     found {} in repo", (Object)r);
                    resolution.repos.add(r);
                    continue;
                }
                logger.debug("     found {} in system", (Object)r);
                resolution.system.add(r);
            }
            this.error(ResolveProcess.format(e, false), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("resolving %s failed with %s", context.getInputResource().getRequirements(null), e);
            resolution.message = e.getMessage();
        }
        return resolution;
    }

    public static class Resolution {
        public Resource resource;
        public boolean succeeded;
        public String message;
        public Set<Resource> resolved = new LinkedHashSet<Resource>();
        public List<Requirement> system = new ArrayList<Requirement>();
        public List<Requirement> repos = new ArrayList<Requirement>();
        public List<Requirement> missing = new ArrayList<Requirement>();
        public List<Requirement> optionals = new ArrayList<Requirement>();
        public List<Requirement> unresolved = new ArrayList<Requirement>();
    }
}

