/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.lib.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ResolverLogger
implements LogService,
AutoCloseable {
    public static final int DEFAULT_LEVEL = 4;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    private final File file;
    private final PrintWriter printer;
    private int level;
    private String log;

    public ResolverLogger() {
        this(4);
    }

    public ResolverLogger(int level) {
        try {
            this.level = level;
            this.file = File.createTempFile("tmp", ".log");
            this.file.deleteOnExit();
            this.printer = IO.writer(this.file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolverLogger(int level, PrintStream out) {
        this.level = level;
        this.file = null;
        this.printer = IO.writer((OutputStream)out, StandardCharsets.UTF_8);
    }

    public void log(int level, String msg, Throwable throwable) {
        switch (level) {
            case 4: {
                this.printer.print("DEBUG: ");
                this.printLog(msg, throwable);
                break;
            }
            case 1: {
                this.printer.print("ERROR: ");
                this.printLog(msg, throwable);
                if (throwable == null) break;
                throwable.printStackTrace(this.printer);
                break;
            }
            case 3: {
                this.printer.print("INFO: ");
                this.printLog(msg, throwable);
                break;
            }
            case 2: {
                this.printer.print("WARNING: ");
                this.printLog(msg, throwable);
                break;
            }
            default: {
                this.printer.print("UNKNOWN[");
                this.printer.print(level);
                this.printer.print("]: ");
                this.printLog(msg, throwable);
            }
        }
        this.printer.flush();
        this.log = null;
    }

    private void printLog(String msg, Throwable throwable) {
        this.printer.print(msg);
        if (throwable != null) {
            this.printer.print(" (");
            this.printer.print(throwable);
            this.printer.print(")");
        }
        this.printer.println();
    }

    public String getLog() {
        block17: {
            if (this.file == null) {
                return "Log was written to supplied PrintStream";
            }
            if (this.log == null) {
                try {
                    if (this.file.length() <= 8001L) {
                        this.log = IO.collect(this.file);
                        break block17;
                    }
                    StringBuilder sb = new StringBuilder(10000);
                    sb.append("Log too large. Split from ").append(this.file.getAbsolutePath()).append("\nsize ").append((this.file.length() + 512L) / 1024L).append(" Kb\n===================\n");
                    byte[] buffer = new byte[4000];
                    try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
                        raf.readFully(buffer);
                        sb.append(new String(buffer, StandardCharsets.UTF_8));
                        sb.append("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\n");
                        raf.seek(raf.length() - (long)buffer.length);
                        raf.readFully(buffer);
                        String s = new String(buffer, StandardCharsets.UTF_8);
                        sb.append(s);
                    }
                    this.log = sb.toString();
                }
                catch (Exception e) {
                    this.log = e.getMessage();
                }
            }
        }
        return this.log;
    }

    @Override
    public void close() {
        IO.close(this.printer);
        IO.delete(this.file);
    }

    public int getLogLevel() {
        return this.level;
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(level, message, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(level, message, exception);
    }
}

