/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Project;
import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.osgi.resource.WireImpl;
import aQute.bnd.service.Registry;
import aQute.lib.strings.Strings;
import aQute.libg.generics.Create;
import aQute.libg.tuple.Pair;
import biz.aQute.resolve.AbstractResolveContext;
import biz.aQute.resolve.BndrunResolveContext;
import biz.aQute.resolve.ResolutionCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.felix.resolver.reason.ReasonException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.log.LogService;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;
import org.osgi.service.resolver.Resolver;

public class ResolveProcess {
    private static final String ARROW = "      \u21d2 ";
    private Map<Resource, List<Wire>> required;
    private Map<Resource, List<Wire>> optional;
    private ResolutionException resolutionException;

    public Map<Resource, List<Wire>> resolveRequired(BndEditModel inputModel, Registry plugins, Resolver resolver, Collection<ResolutionCallback> callbacks, LogService log) throws ResolutionException {
        try {
            return this.resolveRequired(inputModel.getProperties(), inputModel.getProject(), plugins, resolver, callbacks, log);
        }
        catch (Exception e) {
            if (e instanceof ResolutionException) {
                throw (ResolutionException)e;
            }
            throw new ResolutionException(e);
        }
    }

    public Map<Resource, List<Wire>> resolveRequired(Processor properties, Project project, Registry plugins, Resolver resolver, Collection<ResolutionCallback> callbacks, LogService log) throws ResolutionException {
        Map<Resource, List<Wire>> wirings;
        this.required = new HashMap<Resource, List<Wire>>();
        this.optional = new HashMap<Resource, List<Wire>>();
        BndrunResolveContext rc = new BndrunResolveContext(properties, project, plugins, log);
        rc.addCallbacks(callbacks);
        try {
            wirings = resolver.resolve(rc);
        }
        catch (ResolutionException re) {
            throw ResolveProcess.augment(rc, re);
        }
        Pair<Resource, List<Wire>> initialRequirement = null;
        for (Map.Entry<Resource, List<Wire>> entry : wirings.entrySet()) {
            if (rc.getInputResource() != entry.getKey()) continue;
            initialRequirement = new Pair<Resource, List<Wire>>(entry.getKey(), entry.getValue());
            break;
        }
        final ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource resource : rc.getMandatoryResources()) {
            block8: for (Requirement req : resource.getRequirements(null)) {
                for (Resource found : wirings.keySet()) {
                    String filterStr = (String)req.getDirectives().get("filter");
                    try {
                        Filter filter = filterStr != null ? FrameworkUtil.createFilter((String)filterStr) : null;
                        for (Capability c : found.getCapabilities(req.getNamespace())) {
                            if (filter == null || !filter.matches(c.getAttributes())) continue;
                            resources.add(found);
                            continue block8;
                        }
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                    }
                }
            }
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : resources) {
            this.addWiredBundle(wirings, resource, arrayList);
        }
        for (Resource resource : arrayList) {
            if (resources.contains(resource)) continue;
            resources.add(resource);
        }
        final LinkedHashMap<Resource, List<Wire>> linkedHashMap = new LinkedHashMap<Resource, List<Wire>>();
        BndrunResolveContext rc2 = new BndrunResolveContext(properties, project, plugins, log){

            @Override
            public Collection<Resource> getMandatoryResources() {
                return resources;
            }

            @Override
            public boolean isInputResource(Resource resource) {
                for (Resource r : resources) {
                    if (!AbstractResolveContext.resourceIdentityEquals(r, resource)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public List<Capability> findProviders(Requirement requirement) {
                List<Capability> toReturn = super.findProviders(requirement);
                if (toReturn.isEmpty() && this.isEffective(requirement) && "optional".equals(requirement.getDirectives().get("resolution"))) {
                    for (Capability cap : this.findProvidersFromRepositories(requirement, new LinkedHashSet<Capability>())) {
                        WireImpl candidateWire;
                        Resource optionalRes = cap.getResource();
                        ArrayList<WireImpl> list = (ArrayList<WireImpl>)linkedHashMap.get(optionalRes);
                        if (list == null) {
                            list = new ArrayList<WireImpl>();
                            linkedHashMap.put(optionalRes, list);
                        }
                        if (list.contains(candidateWire = new WireImpl(cap, requirement))) continue;
                        list.add(candidateWire);
                    }
                }
                return toReturn;
            }
        };
        rc2.addCallbacks(callbacks);
        try {
            wirings = resolver.resolve(rc2);
        }
        catch (ResolutionException re) {
            throw ResolveProcess.augment(rc2, re);
        }
        if (initialRequirement != null) {
            wirings.put(initialRequirement.getFirst(), initialRequirement.getSecond());
        }
        Map<Resource, List<Wire>> result = ResolveProcess.invertWirings(wirings, rc2);
        ResolveProcess.removeFrameworkAndInputResources(result, rc2);
        this.required.putAll(result);
        this.optional = ResolveProcess.tidyUpOptional(wirings, linkedHashMap, log);
        return result;
    }

    public static ResolutionException augment(AbstractResolveContext context, ResolutionException re) {
        Set<Requirement> unresolved = Create.set();
        unresolved.addAll(re.getUnresolvedRequirements());
        unresolved.addAll(context.getFailed());
        return ResolveProcess.augment(unresolved, context, re);
    }

    public static ResolutionException augment(ResolveContext context, ResolutionException re) throws ResolutionException {
        return ResolveProcess.augment(re.getUnresolvedRequirements(), context, re);
    }

    public static String format(ResolutionException re) {
        return ResolveProcess.format(re, true);
    }

    public static String format(ResolutionException re, boolean reportOptional) {
        ArrayList<Requirement> chain = new ArrayList<Requirement>();
        for (Throwable cause = re; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ReasonException)) continue;
            ReasonException mre = (ReasonException)cause;
            chain.addAll(mre.getUnresolvedRequirements());
        }
        Map<Boolean, List<Requirement>> requirements = re.getUnresolvedRequirements().stream().filter(req -> !chain.contains(req)).collect(Collectors.partitioningBy(ResolveProcess::isOptional));
        try (Formatter f = new Formatter();){
            f.format("Resolution failed. Capabilities satisfying the following requirements could not be found:", new Object[0]);
            String prefix = "    ";
            for (Requirement req2 : chain) {
                f.format("%n%s[%s]", prefix, req2.getResource());
                prefix = "    ".equals(prefix) ? ARROW : "    " + prefix;
                ResolveProcess.format(f, prefix, req2);
                prefix = "    " + prefix;
            }
            requirements.get(Boolean.FALSE).stream().collect(Collectors.groupingBy(Requirement::getResource)).forEach(ResolveProcess.formatGroup(f));
            List<Requirement> optional = requirements.get(Boolean.TRUE);
            if (!optional.isEmpty() && reportOptional) {
                f.format("%nThe following requirements are optional:", new Object[0]);
                optional.stream().collect(Collectors.groupingBy(Requirement::getResource)).forEach(ResolveProcess.formatGroup(f));
            }
            String string = f.toString();
            return string;
        }
    }

    static BiConsumer<? super Resource, ? super List<Requirement>> formatGroup(Formatter f) {
        return (resource, list) -> {
            f.format("%n    [%s]", resource);
            list.forEach(req -> ResolveProcess.format(f, ARROW, req));
        };
    }

    static void format(Formatter f, String prefix, Requirement req) {
        String filter = (String)req.getDirectives().get("filter");
        f.format("%n%s%s: %s", prefix, req.getNamespace(), filter);
    }

    public static String format(Collection<Requirement> requirements) {
        HashSet<Requirement> mandatory = new HashSet<Requirement>();
        HashSet<Requirement> optional = new HashSet<Requirement>();
        for (Requirement req : requirements) {
            if (ResolveProcess.isOptional(req)) {
                optional.add(req);
                continue;
            }
            mandatory.add(req);
        }
        try (Formatter f = new Formatter();){
            f.format("%n  Mandatory:", new Object[0]);
            for (Requirement req : mandatory) {
                f.format("%n    [%-19s] %s", req.getNamespace(), req);
            }
            f.format("%n  Optional:", new Object[0]);
            for (Requirement req : optional) {
                f.format("%n    [%-19s] %s", req.getNamespace(), req);
            }
            String string = f.toString();
            return string;
        }
    }

    private static boolean isOptional(Requirement req) {
        String resolution = (String)req.getDirectives().get("resolution");
        if (resolution == null) {
            return false;
        }
        return "optional".equals(resolution);
    }

    private static ResolutionException augment(Collection<Requirement> unresolved, ResolveContext context, ResolutionException re) {
        if (unresolved.isEmpty()) {
            return re;
        }
        long deadline = System.currentTimeMillis() + 1000L;
        HashSet<Requirement> list = new HashSet<Requirement>(unresolved);
        HashSet<Resource> resources = new HashSet<Resource>();
        try {
            for (Requirement r : unresolved) {
                Requirement find = ResolveProcess.missing(context, r, resources, deadline);
                if (find == null) continue;
                list.add(find);
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return new ResolutionException(re.getMessage(), re, list);
    }

    private static Requirement missing(ResolveContext context, Requirement rq, Set<Resource> resources, long deadline) throws TimeoutException {
        resources.add(rq.getResource());
        if (deadline < System.currentTimeMillis()) {
            throw new TimeoutException();
        }
        List<Capability> providers = context.findProviders(rq);
        if (providers.isEmpty()) {
            return rq;
        }
        HashSet<Resource> candidates = new HashSet<Resource>();
        Requirement missing = null;
        block0: for (Capability cap : providers) {
            for (Requirement sub : cap.getResource().getRequirements(null)) {
                List<Capability> subProviders = context.findProviders(sub);
                if (!subProviders.isEmpty()) continue;
                if (missing != null) continue block0;
                missing = sub;
                continue block0;
            }
            candidates.add(cap.getResource());
        }
        if (candidates.isEmpty()) {
            assert (missing != null);
            return missing;
        }
        Requirement initialMissing = missing;
        missing = null;
        candidates.removeAll(resources);
        resources.addAll(candidates);
        block2: for (Resource resource : candidates) {
            for (Requirement requirement : resource.getRequirements(null)) {
                Requirement r1 = ResolveProcess.missing(context, requirement, resources, deadline);
                if (r1 == null || missing == null) continue;
                missing = r1;
                continue block2;
            }
            return null;
        }
        return missing == null ? initialMissing : missing;
    }

    private void addWiredBundle(Map<Resource, List<Wire>> wirings, Resource resource, List<Resource> result) {
        List reqs = resource.getRequirements("osgi.wiring.bundle");
        for (Requirement req : reqs) {
            List<Wire> wrs = wirings.get(resource);
            for (Wire w : wrs) {
                Resource res;
                if (!w.getRequirement().equals((Object)req) || (res = w.getProvider()) == null || result.contains(res)) continue;
                result.add(res);
                this.addWiredBundle(wirings, res, result);
            }
        }
    }

    private static void removeFrameworkAndInputResources(Map<Resource, List<Wire>> resourceMap, AbstractResolveContext rc) {
        resourceMap.keySet().removeIf(rc::isSystemResource);
    }

    private static Map<Resource, List<Wire>> invertWirings(Map<Resource, ? extends Collection<Wire>> wirings, AbstractResolveContext rc) {
        HashMap<Resource, List<Wire>> inverted = new HashMap<Resource, List<Wire>>();
        for (Map.Entry<Resource, ? extends Collection<Wire>> entry : wirings.entrySet()) {
            Resource requirer = entry.getKey();
            for (Wire wire : entry.getValue()) {
                Resource provider = ResolveProcess.findResolvedProvider(wire, wirings.keySet(), rc);
                if (provider == requirer) continue;
                LinkedList<Wire> incoming = (LinkedList<Wire>)inverted.get(provider);
                if (incoming == null) {
                    incoming = new LinkedList<Wire>();
                    inverted.put(provider, incoming);
                }
                incoming.add(wire);
            }
        }
        return inverted;
    }

    private static Resource findResolvedProvider(Wire wire, Set<Resource> resources, AbstractResolveContext rc) {
        Capability capability = wire.getCapability();
        Resource resource = capability.getResource();
        if (rc.isSystemResource(resource) || ResourceUtils.isFragment(resource) && resources.contains(resource)) {
            return resource;
        }
        for (Resource resolved : resources) {
            for (Capability resolvedCap : resolved.getCapabilities(capability.getNamespace())) {
                if (!ResourceUtils.matches(wire.getRequirement(), resolvedCap)) continue;
                return resolved;
            }
        }
        throw new IllegalStateException(Strings.format("The capability for wire %s was not associated with a resource in the resolution", wire));
    }

    private static Map<Resource, List<Wire>> tidyUpOptional(Map<Resource, List<Wire>> required, Map<Resource, List<Wire>> discoveredOptional, LogService log) {
        HashMap<Resource, List<Wire>> toReturn = new HashMap<Resource, List<Wire>>();
        HashSet<Capability> requiredIdentities = new HashSet<Capability>();
        for (Resource r : required.keySet()) {
            Capability normalisedIdentity = ResolveProcess.toPureIdentity(r, log);
            if (normalisedIdentity == null) continue;
            requiredIdentities.add(normalisedIdentity);
        }
        HashSet<Capability> acceptedIdentities = new HashSet<Capability>();
        for (Map.Entry<Resource, List<Wire>> entry : discoveredOptional.entrySet()) {
            Capability optionalIdentity;
            Resource optionalResource = entry.getKey();
            if (required.containsKey(optionalResource) || requiredIdentities.contains(optionalIdentity = ResolveProcess.toPureIdentity(optionalResource, log))) continue;
            ArrayList<Wire> validWires = new ArrayList<Wire>();
            block2: for (Wire optionalWire : entry.getValue()) {
                Resource requirer = optionalWire.getRequirer();
                Capability requirerIdentity = ResolveProcess.toPureIdentity(requirer, log);
                if (!required.containsKey(requirer)) continue;
                Requirement req = optionalWire.getRequirement();
                List<Wire> requiredWires = required.get(requirer);
                for (Wire requiredWire : requiredWires) {
                    if (!req.equals((Object)requiredWire.getRequirement())) continue;
                    continue block2;
                }
                validWires.add(optionalWire);
            }
            if (validWires.isEmpty()) continue;
            if (acceptedIdentities.add(optionalIdentity)) {
                toReturn.put(optionalResource, validWires);
                continue;
            }
            log.log(3, "Discarding the optional resource " + optionalResource + " because another optional resource with the identity " + optionalIdentity + " has already been selected. This usually happens when the same bundle is present in multiple repositories.");
        }
        return toReturn;
    }

    private static Capability toPureIdentity(Resource r, LogService log) {
        List capabilities = r.getCapabilities("osgi.identity");
        if (capabilities.size() != 1) {
            log.log(2, "The resource " + r + " has the wrong number of identity capabilities " + capabilities.size());
            return null;
        }
        try {
            return CapReqBuilder.copy((Capability)capabilities.get(0), null);
        }
        catch (Exception e) {
            log.log(1, "Unable to copy the capability " + capabilities.get(0));
            return null;
        }
    }

    public ResolutionException getResolutionException() {
        return this.resolutionException;
    }

    public Collection<Resource> getRequiredResources() {
        if (this.required == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.required.keySet());
    }

    public Collection<Resource> getOptionalResources() {
        if (this.optional == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.optional.keySet());
    }

    public Collection<Wire> getRequiredReasons(Resource resource) {
        List<Wire> wires = this.required.get(resource);
        if (wires == null) {
            wires = Collections.emptyList();
        }
        return wires;
    }

    public Collection<Wire> getOptionalReasons(Resource resource) {
        List<Wire> wires = this.optional.get(resource);
        if (wires == null) {
            wires = Collections.emptyList();
        }
        return wires;
    }
}

