/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.Strategy;
import biz.aQute.resolve.BndResolver;
import biz.aQute.resolve.BndrunResolveContext;
import biz.aQute.resolve.ResolutionCallback;
import biz.aQute.resolve.ResolveProcess;
import biz.aQute.resolve.ResolverLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.log.LogService;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectResolver
extends Processor
implements ResolutionCallback {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResolver.class);
    private final Project project;
    private Map<Resource, List<Wire>> resolution;
    private final ReporterLogger log = new ReporterLogger(0);
    private final Collection<ResolutionCallback> cbs = new ArrayList<ResolutionCallback>();

    public ProjectResolver(Project project) {
        super(project);
        this.getSettings(project);
        this.project = project;
    }

    public Map<Resource, List<Wire>> resolve() throws ResolutionException {
        try (ResolverLogger logger = new ResolverLogger();){
            ResolveProcess resolve = new ResolveProcess();
            BndResolver resolver = new BndResolver(logger);
            Map<Resource, List<Wire>> map = this.resolution = resolve.resolveRequired(this, this.project, this, resolver, this.cbs, this.log);
            return map;
        }
    }

    @Override
    public void processCandidates(Requirement requirement, Set<Capability> wired, List<Capability> candidates) {
    }

    public List<Container> getRunBundles() throws Exception {
        Map<Resource, List<Wire>> resolution = this.resolution;
        if (resolution == null) {
            resolution = this.resolve();
        }
        ArrayList<Container> containers = new ArrayList<Container>();
        for (Resource r : resolution.keySet()) {
            ResourceUtils.IdentityCapability identity = ResourceUtils.getIdentityCapability(r);
            if (identity == null) {
                this.error("Identity for %s not found", r);
                continue;
            }
            Container bundle = this.project.getBundle(identity.osgi_identity(), identity.version().toString(), Strategy.EXACT, null);
            if (bundle == null) {
                this.error("Bundle for %s-%s not found", identity.osgi_identity(), identity.version());
                continue;
            }
            containers.add(bundle);
        }
        return containers;
    }

    public void validate() throws Exception {
        BndrunResolveContext context = this.getContext();
        String runrequires = this.getProperty("-runrequires");
        if (runrequires == null || runrequires.isEmpty()) {
            this.error("Requires the %s instruction to be set", "-runrequires");
        } else {
            if ("<<EMPTY>>".equals(runrequires)) {
                return;
            }
            this.exists(context, runrequires, "Initial requirement %s cannot be resolved to an entry in the repositories");
        }
        String framework = this.getProperty("-runfw");
        if (framework == null) {
            this.error("No framework is set", new Object[0]);
        } else {
            this.exists(context, framework, "Framework not found");
        }
    }

    private void exists(BndrunResolveContext context, String framework, String msg) throws Exception {
        Parameters p = new Parameters(framework, this);
        for (Map.Entry<String, Attrs> e : p.entrySet()) {
            this.exists(context, e.getKey(), e.getValue(), msg);
        }
    }

    private void exists(BndrunResolveContext context, String namespace, Attrs attrs, String msg) throws Exception {
        Requirement req = CapReqBuilder.getRequirementFrom(namespace, attrs);
        List<Capability> caps = context.findProviders(req);
        if (caps == null || caps.isEmpty()) {
            this.error(msg, req);
        }
    }

    public BndrunResolveContext getContext() {
        return new BndrunResolveContext(this, this.project, this, this.log);
    }

    public ResourceUtils.IdentityCapability getResource(String bsn, String version) {
        Requirement requirement = CapReqBuilder.createBundleRequirement(bsn, version).buildSyntheticRequirement();
        List<Capability> result = this.getContext().findProviders(requirement);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return ResourceUtils.getIdentityCapability(result.get(0).getResource());
    }

    private final class ReporterLogger
    extends org.apache.felix.resolver.Logger
    implements LogService {
        ReporterLogger(int i) {
            super(i);
        }

        @Override
        protected void doLog(int level, String msg, Throwable throwable) {
            switch (level) {
                case 1: {
                    if (throwable == null) {
                        ProjectResolver.this.error("%s", msg);
                        break;
                    }
                    ProjectResolver.this.exception(throwable, "%s", msg);
                    break;
                }
                case 2: {
                    if (throwable == null) {
                        ProjectResolver.this.warning("%s", msg);
                        break;
                    }
                    ProjectResolver.this.warning("%s: %s", msg, throwable);
                    break;
                }
                case 3: {
                    logger.info("{}", (Object)msg, (Object)throwable);
                    break;
                }
                default: {
                    logger.debug("{}", (Object)msg, (Object)throwable);
                }
            }
        }

        public void log(ServiceReference sr, int level, String message) {
            this.doLog(level, this.toString(sr) + message, null);
        }

        public void log(ServiceReference sr, int level, String message, Throwable exception) {
            this.doLog(level, this.toString(sr) + message, exception);
        }

        private String toString(ServiceReference<?> sr) {
            return "[" + sr.getProperty("service.id") + "] ";
        }
    }
}

