/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.service.reporter.Reporter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReporter
extends org.apache.felix.resolver.Logger
implements LogService {
    private static final Logger logger = LoggerFactory.getLogger(LogReporter.class);
    private Reporter reporter;

    public LogReporter(Reporter reporter) {
        super(2);
        this.reporter = reporter;
    }

    public void log(ServiceReference sr, int level, String message) {
        this.getLevel(level).log(sr, message);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.getLevel(level).log(sr, message, exception);
    }

    private Silent getLevel(int usedLevel) {
        if (usedLevel <= this.getLogLevel()) {
            switch (usedLevel) {
                case 1: {
                    return new Error();
                }
                case 2: {
                    return new Warning();
                }
            }
            return new Trace();
        }
        return new Silent();
    }

    class Silent {
        Silent() {
        }

        public void log(String message) {
        }

        public void log(String message, Throwable exception) {
        }

        public void log(ServiceReference<?> sr, String message) {
        }

        public void log(ServiceReference<?> sr, String message, Throwable exception) {
        }
    }

    class Trace
    extends Silent {
        Trace() {
        }

        @Override
        public void log(String message) {
            logger.debug("{}", (Object)message);
        }

        @Override
        public void log(String message, Throwable exception) {
            logger.debug("{}", (Object)message, (Object)exception);
        }

        @Override
        public void log(ServiceReference<?> sr, String message) {
            logger.debug("{} ({})", (Object)message, (Object)sr);
        }

        @Override
        public void log(ServiceReference<?> sr, String message, Throwable exception) {
            logger.debug("{} ({})", message, sr, exception);
        }
    }

    class Warning
    extends Silent {
        Warning() {
        }

        @Override
        public void log(String message) {
            LogReporter.this.reporter.warning("%s", message);
        }

        @Override
        public void log(String message, Throwable exception) {
            LogReporter.this.reporter.warning("%s : %s", message, exception);
        }

        @Override
        public void log(ServiceReference<?> sr, String message) {
            LogReporter.this.reporter.warning("%s (%s)", message, sr);
        }

        @Override
        public void log(ServiceReference<?> sr, String message, Throwable exception) {
            LogReporter.this.reporter.warning("%s : %s (%s)", message, exception, sr);
        }
    }

    class Error
    extends Silent {
        Error() {
        }

        @Override
        public void log(String message) {
            LogReporter.this.reporter.error("%s", message);
        }

        @Override
        public void log(String message, Throwable exception) {
            LogReporter.this.reporter.error("%s : %s", message, exception);
        }

        @Override
        public void log(ServiceReference<?> sr, String message) {
            LogReporter.this.reporter.error("%s (%s)", message, sr);
        }

        @Override
        public void log(ServiceReference<?> sr, String message, Throwable exception) {
            LogReporter.this.reporter.error("%s : %s (%s)", message, exception, sr);
        }
    }
}

