/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.EE;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.AggregateRepository;
import aQute.bnd.osgi.repository.AugmentRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.resolve.hook.ResolverHook;
import aQute.lib.converter.Converter;
import biz.aQute.resolve.AbstractResolveContext;
import biz.aQute.resolve.ResolutionCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.log.LogService;
import org.osgi.service.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BndrunResolveContext
extends AbstractResolveContext {
    private static final Logger logger = LoggerFactory.getLogger(BndrunResolveContext.class);
    private static final String BND_AUGMENT = "bnd.augment";
    public static final String RUN_EFFECTIVE_INSTRUCTION = "-resolve.effective";
    public static final String PROP_RESOLVE_PREFERENCES = "-resolve.preferences";
    private Registry registry;
    private Parameters resolvePrefs;
    private final Processor properties;
    private Project project;
    private boolean initialized;

    @Deprecated
    public BndrunResolveContext(BndEditModel runModel, Registry registry, LogService log) {
        super(log);
        try {
            this.registry = registry;
            this.properties = runModel.getProperties();
            this.project = runModel.getProject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BndrunResolveContext(Processor runModel, Project project, Registry registry, LogService log) {
        super(log);
        try {
            this.registry = registry;
            this.properties = runModel;
            this.project = project;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            Integer level;
            if (this.getLevel() <= 0 && (level = Converter.cnv(Integer.class, (Object)this.properties.getProperty("-resolvedebug", "0"))) != null) {
                this.setLevel(level);
            }
            this.loadPreferences();
            Processor augments = this.loadRepositories();
            this.constructBlacklist(augments);
            Map<String, Set<String>> effectiveSet = this.loadEffectiveSet();
            if (effectiveSet != null) {
                this.addEffectiveSet(effectiveSet);
            }
            this.setInputResource(this.constructInputRequirements());
            ResourceBuilder system = new ResourceBuilder();
            String distro = this.properties.mergeProperties("-distro");
            if (distro != null && !distro.trim().isEmpty()) {
                this.loadPath(system, distro, "-distro");
                this.loadProvidedCapabilities(system);
            } else {
                EE tmp = EE.parse(this.properties.getProperty("-runee"));
                EE ee = tmp != null ? tmp : EE.JavaSE_1_6;
                system.addAllExecutionEnvironments(ee);
                Parameters systemPackages = new Parameters(this.properties.mergeProperties("-runsystempackages"), this.project);
                system.addExportPackages(systemPackages);
                Parameters systemCapabilities = new Parameters(this.properties.mergeProperties("-runsystemcapabilities"), this.project);
                system.addProvideCapabilities(systemCapabilities);
                this.loadProvidedCapabilities(system);
                this.loadFramework(system);
                String runpath = this.properties.mergeProperties("-runpath");
                if (runpath != null && !runpath.trim().isEmpty()) {
                    this.loadPath(system, runpath, "-runpath");
                }
            }
            this.setSystemResource(system.build());
        }
        catch (Exception e) {
            this.log.log(1, e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        super.init();
    }

    private void loadProvidedCapabilities(ResourceBuilder system) throws Exception {
        Parameters providedCapabilities = new Parameters(this.properties.mergeProperties("-runprovidedcapabilities"), this.project);
        system.addProvideCapabilities(providedCapabilities);
    }

    void loadFramework(ResourceBuilder system) throws Exception {
        Parameters parameters = new Parameters(this.properties.getProperty("-runfw"), this.project);
        if (parameters.isEmpty()) {
            this.log.log(2, "No -runfw set");
            return;
        }
        if (parameters.size() > 1) {
            throw new IllegalArgumentException("Too many frameworks specified in -runfw (" + parameters + ")");
        }
        Map.Entry<String, Attrs> bsn = parameters.entrySet().iterator().next();
        String name = bsn.getKey();
        String version = bsn.getValue().getVersion();
        this.log.log(3, "Using frameowork " + name + ";" + version);
        if ("none".equals(name)) {
            return;
        }
        Resource framework = this.getHighestResource(name, version);
        if (framework == null) {
            this.log.log(1, "Cannot find framework " + name + ";" + version);
        } else {
            super.setFramework(system, framework);
        }
    }

    @Override
    public void loadPath(ResourceBuilder system, String path, String what) throws Exception {
        if (this.project != null) {
            List<Container> containers = Container.flatten(this.project.getBundles(Strategy.HIGHEST, path, what));
            for (Container c : containers) {
                Manifest manifest = c.getManifest();
                if (manifest == null) continue;
                ResourceBuilder rb = new ResourceBuilder();
                rb.addManifest(Domain.domain(manifest));
                this.addSystemResource(system, rb.build());
            }
        } else {
            super.loadPath(system, path, what);
        }
    }

    Map<String, Set<String>> loadEffectiveSet() {
        String effective = this.properties.getProperty(RUN_EFFECTIVE_INSTRUCTION);
        if (effective == null) {
            return null;
        }
        HashMap<String, Set<String>> effectiveSet = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Attrs> entry : new Parameters(effective, this.project).entrySet()) {
            String skip = entry.getValue().get("skip:");
            HashSet toSkip = skip == null ? new HashSet() : new HashSet<String>(Arrays.asList(skip.split(",")));
            effectiveSet.put(entry.getKey(), toSkip);
        }
        return effectiveSet;
    }

    private Processor loadRepositories() throws Exception {
        Collection<Repository> orderedRepositories;
        List<Repository> allRepos = this.registry.getPlugins(Repository.class);
        String rn = this.properties.mergeProperties("-runrepos");
        if (rn == null) {
            orderedRepositories = allRepos;
        } else {
            Parameters repoNames = new Parameters(rn, this.project);
            HashMap<String, Repository> repoNameMap = new HashMap<String, Repository>(allRepos.size());
            for (Repository repo : allRepos) {
                String name = repo instanceof RepositoryPlugin ? ((RepositoryPlugin)((Object)repo)).getName() : repo.toString();
                repoNameMap.put(name, repo);
            }
            orderedRepositories = new ArrayList<Repository>();
            for (String repoName : repoNames.keySet()) {
                Repository repo = (Repository)repoNameMap.get(repoName);
                if (repo == null) continue;
                orderedRepositories.add(repo);
            }
        }
        Processor repositoryAugments = this.findRepositoryAugments(orderedRepositories);
        Parameters augments = new Parameters(repositoryAugments.mergeProperties("-augment"), this.project);
        augments.putAll(new Parameters(this.properties.mergeProperties("-augment"), this.project));
        if (!augments.isEmpty()) {
            AggregateRepository aggregate = new AggregateRepository(orderedRepositories);
            AugmentRepository augment = new AugmentRepository(augments, aggregate);
            orderedRepositories = Collections.singleton(augment);
        }
        for (Repository repository : orderedRepositories) {
            super.addRepository(repository);
        }
        return repositoryAugments;
    }

    private Processor findRepositoryAugments(Collection<Repository> orderedRepositories) {
        Processor main = new Processor();
        RequirementBuilder rb = new RequirementBuilder(BND_AUGMENT);
        rb.filter("(path=*)");
        Requirement req = rb.buildSyntheticRequirement();
        for (Repository r : orderedRepositories) {
            Map<Requirement, Collection<Capability>> found = r.findProviders(Collections.singleton(req));
            Collection<Capability> capabilities = found.get(req);
            if (capabilities == null) continue;
            for (Capability capability : capabilities) {
                this.findAdditionalAugmentsFromResource(main, capability);
            }
        }
        return main;
    }

    /*
     * Exception decompiling
     */
    private void findAdditionalAugmentsFromResource(Processor augments, Capability capability) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isSystemResource(Resource resource) {
        Resource systemResource = this.getSystemResource();
        return resource == systemResource;
    }

    Resource constructInputRequirements() throws Exception {
        ResourceBuilder resBuilder = new ResourceBuilder();
        CapReqBuilder identity = new CapReqBuilder("osgi.identity").addAttribute("osgi.identity", "<<INITIAL>>");
        resBuilder.addCapability(identity);
        Parameters inputRequirements = new Parameters(this.properties.mergeProperties("-runrequires"), this.project);
        if (inputRequirements != null && !inputRequirements.isEmpty()) {
            List<Requirement> requires = CapReqBuilder.getRequirementsFrom(inputRequirements);
            resBuilder.addRequirements(requires);
        }
        return resBuilder.build();
    }

    private void constructBlacklist(Processor augments) throws Exception {
        Parameters blacklist = new Parameters(augments.mergeProperties("-runblacklist"), this.project);
        blacklist.putAll(new Parameters(this.properties.mergeProperties("-runblacklist"), this.project));
        if (blacklist != null && !blacklist.isEmpty()) {
            List<Requirement> reject = CapReqBuilder.getRequirementsFrom(blacklist);
            this.setBlackList(reject);
        }
    }

    private void loadPreferences() {
        this.resolvePrefs = new Parameters(this.properties.getProperty(PROP_RESOLVE_PREFERENCES), this.project);
    }

    @Override
    protected void postProcessProviders(Requirement requirement, Set<Capability> wired, List<Capability> candidates) {
        if (candidates.size() == 0) {
            return;
        }
        for (ResolverHook resolverHook : this.registry.getPlugins(ResolverHook.class)) {
            resolverHook.filterMatches(requirement, candidates);
        }
        boolean prefsUsed = false;
        if (this.resolvePrefs != null && !this.resolvePrefs.isEmpty()) {
            LinkedList<Capability> insertions = new LinkedList<Capability>();
            Iterator<Capability> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                Capability cap = iterator.next();
                if (!this.resolvePrefs.containsKey(BndrunResolveContext.getResourceIdentity(cap.getResource()))) continue;
                iterator.remove();
                insertions.add(cap);
            }
            if (!insertions.isEmpty()) {
                candidates.addAll(0, insertions);
                prefsUsed = true;
            }
        }
        if (!prefsUsed) {
            for (ResolutionCallback callback : this.getCallbacks()) {
                callback.processCandidates(requirement, wired, candidates);
            }
        }
    }
}

