/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.clauses.HeaderClause;
import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.build.model.conversions.CollectionFormatter;
import aQute.bnd.build.model.conversions.Converter;
import aQute.bnd.build.model.conversions.HeaderClauseFormatter;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.properties.Document;
import aQute.lib.io.IO;
import biz.aQute.resolve.ProjectResolver;
import biz.aQute.resolve.WorkspaceResourcesRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bndrun
extends Run {
    private static final Logger logger = LoggerFactory.getLogger(Bndrun.class);
    private static final Converter<String, Collection<? extends HeaderClause>> runbundlesListFormatter = new CollectionFormatter<HeaderClause>(",", new HeaderClauseFormatter(), null, "", "");
    private static final Converter<String, Collection<? extends HeaderClause>> runbundlesWrappedFormatter = new CollectionFormatter<HeaderClause>(",\\\n\t", new HeaderClauseFormatter(), null);

    public static Bndrun createBndrun(Workspace workspace, File file) throws Exception {
        Processor processor;
        if (workspace != null) {
            Bndrun run = new Bndrun(workspace, file);
            if (run.getProperties().get("-standalone") == null) {
                return run;
            }
            processor = run;
        } else {
            processor = new Processor();
            processor.setProperties(file);
        }
        Workspace standaloneWorkspace = Workspace.createStandaloneWorkspace(processor, file.toURI());
        Bndrun run = new Bndrun(standaloneWorkspace, file);
        return run;
    }

    public Bndrun(Workspace workspace, File propertiesFile) throws Exception {
        super(workspace, propertiesFile);
        if (!this.isStandalone()) {
            this.addBasicPlugin(new WorkspaceResourcesRepository(this.getWorkspace()));
        }
    }

    public String resolve(boolean failOnChanges, boolean writeOnChanges) throws Exception {
        return this.resolve(failOnChanges, writeOnChanges, runbundlesListFormatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> T resolve(boolean failOnChanges, boolean writeOnChanges, Converter<T, Collection<? extends HeaderClause>> runbundlesFormatter) throws Exception {
        projectResolver = new ProjectResolver(this);
        var5_5 = null;
        try {
            block27: {
                block26: {
                    resolution = projectResolver.resolve();
                    if (projectResolver.isOk()) break block26;
                    var7_8 = runbundlesFormatter.convert(Collections.emptyList());
                    this.getInfo(projectResolver);
                    return var7_8;
                }
                try {
                    resources = resolution.keySet();
                    runBundles = new ArrayList<VersionedClause>();
                    for (Resource resource : resources) {
                        runBundle = ResourceUtils.toVersionClause(resource, "[===,==+)");
                        if (runBundles.contains(runBundle)) continue;
                        runBundles.add(runBundle);
                    }
                    Collections.sort(runBundles, new Comparator<VersionedClause>(){

                        @Override
                        public int compare(VersionedClause a, VersionedClause b) {
                            int diff = a.getName().compareTo(b.getName());
                            return diff != 0 ? diff : a.getVersionRange().compareTo(b.getVersionRange());
                        }
                    });
                    runFile = this.getPropertiesFile();
                    bem = new BndEditModel(this.getWorkspace());
                    doc = new Document(IO.collect(runFile));
                    bem.loadFrom(doc);
                    bemRunBundles = bem.getRunBundles();
                    if (bemRunBundles == null) {
                        bemRunBundles = new ArrayList<VersionedClause>();
                    }
                    originalRunbundlesString = Bndrun.runbundlesWrappedFormatter.convert(bemRunBundles);
                    Bndrun.logger.debug("Original -runbundles was:\n\t {}", (Object)originalRunbundlesString);
                    runbundlesString = Bndrun.runbundlesWrappedFormatter.convert(runBundles);
                    Bndrun.logger.debug("Resolved -runbundles is:\n\t {}", (Object)runbundlesString);
                    deltaAdd = new ArrayList<E>(runBundles);
                    deltaAdd.removeAll(bemRunBundles);
                    deltaRemove = new ArrayList<VersionedClause>(bemRunBundles);
                    deltaRemove.removeAll(runBundles);
                    added = bemRunBundles.addAll(deltaAdd);
                    removed = bemRunBundles.removeAll(deltaRemove);
                    if (!added && !removed) ** GOTO lbl66
                    if (!failOnChanges || bemRunBundles.isEmpty()) break block27;
                    this.error("The runbundles have changed. Failing the build!\nWas: %s\nIs: %s", new Object[]{originalRunbundlesString, runbundlesString});
                    var19_22 = runbundlesFormatter.convert(Collections.emptyList());
                }
                catch (Throwable var21_26) {
                    try {
                        this.getInfo(projectResolver);
                        throw var21_26;
                    }
                    catch (Throwable var6_7) {
                        var5_5 = var6_7;
                        throw var6_7;
                    }
                }
                this.getInfo(projectResolver);
                return var19_22;
            }
            if (writeOnChanges) {
                bem.setRunBundles(bemRunBundles);
                runBundlesProperty = bem.getDocumentChanges().get("-runbundles");
                Bndrun.logger.debug("Writing changes to {}", (Object)runFile.getAbsolutePath());
                Bndrun.logger.debug("{}:{}", (Object)"-runbundles", (Object)runBundlesProperty);
                bem.saveChangesTo(doc);
                IO.store((Object)doc.get(), runFile);
            }
lbl66:
            // 4 sources

            var19_23 = runbundlesFormatter.convert(bemRunBundles);
            this.getInfo(projectResolver);
            return var19_23;
        }
        finally {
            if (projectResolver != null) {
                if (var5_5 != null) {
                    try {
                        projectResolver.close();
                    }
                    catch (Throwable var8_10) {
                        var5_5.addSuppressed(var8_10);
                    }
                } else {
                    projectResolver.close();
                }
            }
        }
    }
}

