/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.uri;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public final class URIUtil {
    private static final Pattern WINDOWS_FILE_PATTERN = Pattern.compile("(?:[a-zA-Z]:[/\\\\]|\\\\\\\\|//)");

    public static URI resolve(URI baseURI, String reference) throws URISyntaxException {
        URI refURI;
        if (reference.isEmpty()) {
            return new URI(baseURI.getScheme(), baseURI.getSchemeSpecificPart(), null);
        }
        if (WINDOWS_FILE_PATTERN.matcher(reference).lookingAt()) {
            return new File(reference).toURI();
        }
        reference = reference.replace('\\', '/');
        try {
            refURI = new URI(reference);
        }
        catch (URISyntaxException e) {
            refURI = new URI(null, reference, null);
        }
        return baseURI.resolve(refURI);
    }
}

